/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.storage.hbase.steps.RangeKeyDistributionMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeKeyDistributionMapperTest {
    MapDriver mapDriver;
    String localTempDir = System.getProperty("java.io.tmpdir") + File.separator;

    @Before
    public void setUp() {
        RangeKeyDistributionMapper mapper = new RangeKeyDistributionMapper();
        this.mapDriver = MapDriver.newMapDriver((Mapper)mapper);
    }

    @Test
    public void testMapperWithoutHeader() throws IOException {
        Text inputKey1 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey2 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 122, 1, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey3 = new Text(new byte[]{2, 2, 2, 2, 2, 2, 2, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey4 = new Text(new byte[]{3, 3, 3, 3, 3, 3, 3, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey5 = new Text(new byte[]{4, 4, 4, 4, 4, 4, 4, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey6 = new Text(new byte[]{5, 5, 5, 5, 5, 5, 5, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey7 = new Text(new byte[]{6, 6, 6, 6, 6, 6, 6, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        this.mapDriver.addInput((Object)inputKey1, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey2, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey3, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey4, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey5, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey6, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey7, (Object)new Text("abc"));
        List result = this.mapDriver.run();
        Assert.assertEquals((long)1L, (long)result.size());
        byte[] key1 = ((Text)((Pair)result.get(0)).getFirst()).getBytes();
        LongWritable value1 = (LongWritable)((Pair)result.get(0)).getSecond();
        Assert.assertArrayEquals((byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7}, (byte[])key1);
        Assert.assertEquals((long)147L, (long)value1.get());
    }

    @Test
    public void testMapperWithHeader() throws IOException {
        Text inputKey1 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey2 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 0, 0, 0, 0, 0, 0, 0, 127, 11, 122, 1, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey3 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 2, 2, 2, 2, 2, 2, 2, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey4 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 3, 3, 3, 3, 3, 3, 3, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey5 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 4, 4, 4, 4, 4, 4, 4, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey6 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 5, 5, 5, 5, 5, 5, 5, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        Text inputKey7 = new Text(new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 6, 6, 6, 6, 6, 6, 6, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7});
        this.mapDriver.addInput((Object)inputKey1, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey2, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey3, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey4, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey5, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey6, (Object)new Text("abc"));
        this.mapDriver.addInput((Object)inputKey7, (Object)new Text("abc"));
        List result = this.mapDriver.run();
        Assert.assertEquals((long)1L, (long)result.size());
        byte[] key1 = ((Text)((Pair)result.get(0)).getFirst()).getBytes();
        LongWritable value1 = (LongWritable)((Pair)result.get(0)).getSecond();
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7, 6, 6, 6, 6, 6, 6, 6, 127, 11, 56, -23, 0, 22, 98, 1, 0, 121, 7}, (byte[])key1);
        Assert.assertEquals((long)273L, (long)value1.get());
    }
}

