/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.storage.hbase.steps.CubeHFileMapper;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CubeHFileMapperTest {
    MapDriver<Text, Text, RowKeyWritable, KeyValue> mapDriver;
    private String cube_name = "FLAT_ITEM_CUBE";

    @Before
    public void setUp() {
        CubeHFileMapper mapper = new CubeHFileMapper();
        this.mapDriver = MapDriver.newMapDriver((Mapper)mapper);
    }

    @Test
    @Ignore(value="not maintaining")
    public void testMapper2() throws IOException {
        this.mapDriver.getConfiguration().set("cube.name", this.cube_name);
        this.mapDriver.addInput((Object)new Text("5\u00072010\u0007tech"), (Object)new Text("35.43\u00072"));
        List result = this.mapDriver.run();
        Assert.assertEquals((long)2L, (long)result.size());
        byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 119, 33, 0, 22, 1, 0, 121, 7};
        ImmutableBytesWritable key = new ImmutableBytesWritable(bytes);
        Pair p1 = (Pair)result.get(0);
        Pair p2 = (Pair)result.get(1);
        Assert.assertEquals((Object)key, (Object)p1.getFirst());
        Assert.assertEquals((Object)"cf1", (Object)new String(((KeyValue)p1.getSecond()).getFamily()));
        Assert.assertEquals((Object)"usd_amt", (Object)new String(((KeyValue)p1.getSecond()).getQualifier()));
        Assert.assertEquals((Object)"35.43", (Object)new String(((KeyValue)p1.getSecond()).getValue()));
        Assert.assertEquals((Object)key, (Object)p2.getFirst());
        Assert.assertEquals((Object)"cf1", (Object)new String(((KeyValue)p2.getSecond()).getFamily()));
        Assert.assertEquals((Object)"item_count", (Object)new String(((KeyValue)p2.getSecond()).getQualifier()));
        Assert.assertEquals((Object)"2", (Object)new String(((KeyValue)p2.getSecond()).getValue()));
    }
}

