/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.translate.FuzzyValueCombination;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FuzzyValueCombinationTest
extends LocalFileMetadataTestCase {
    static final TableDesc table = new TableDesc();
    static TblColRef col1;
    static TblColRef col2;
    static TblColRef col3;

    @BeforeClass
    public static void setUp() throws Exception {
        FuzzyValueCombinationTest.staticCreateTestMetadata((String[])new String[0]);
        col1 = FuzzyValueCombinationTest.col(1, table);
        col2 = FuzzyValueCombinationTest.col(2, table);
        col3 = FuzzyValueCombinationTest.col(3, table);
    }

    @AfterClass
    public static void after() throws Exception {
        FuzzyValueCombinationTest.cleanAfterClass();
    }

    private static TblColRef col(int i, TableDesc t) {
        return TblColRef.mockup((TableDesc)t, (int)i, (String)("Col" + i), (String)"string");
    }

    @Test
    public void testBasics() {
        System.out.println("test basics ============================================================================");
        HashMap values = Maps.newHashMap();
        values.put(col1, this.set("a", "b", "c"));
        values.put(col2, this.set("x", "y", "z"));
        List result = FuzzyValueCombination.calculate((Map)values, (long)10L);
        for (Map item : result) {
            System.out.println(item);
        }
        Assert.assertEquals((long)9L, (long)result.size());
    }

    @Test
    public void testSomeNull() {
        System.out.println("test some null ============================================================================");
        HashMap values = Maps.newHashMap();
        values.put(col1, this.set("a", "b", "c"));
        values.put(col2, this.set(new String[0]));
        values.put(col3, this.set("x", "y", "z"));
        List result = FuzzyValueCombination.calculate((Map)values, (long)10L);
        for (Map item : result) {
            System.out.println(item);
        }
        Assert.assertEquals((long)9L, (long)result.size());
    }

    @Test
    public void testAllNulls() {
        System.out.println("test all nulls ============================================================================");
        HashMap values = Maps.newHashMap();
        values.put(col1, this.set(new String[0]));
        values.put(col2, this.set(new String[0]));
        values.put(col3, this.set(new String[0]));
        List result = FuzzyValueCombination.calculate((Map)values, (long)10L);
        for (Map item : result) {
            System.out.println(item);
        }
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCap() {
        System.out.println("test cap ============================================================================");
        HashMap values = Maps.newHashMap();
        values.put(col1, this.set("1", "2", "3", "4"));
        values.put(col2, this.set("a", "b", "c"));
        values.put(col3, this.set("x", "y", "z"));
        List result = FuzzyValueCombination.calculate((Map)values, (long)10L);
        for (Map item : result) {
            System.out.println(item);
        }
        Assert.assertEquals((long)0L, (long)result.size());
    }

    private Set<String> set(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    static {
        table.setName("table");
        table.setDatabase("default");
    }
}

