/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.datagen;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.datagen.ColumnGenerator;
import org.apache.kylin.source.datagen.TableGenConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDataGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ModelDataGenerator.class);
    private final DataModelDesc model;
    private final int targetRows;
    private final ResourceStore outputStore;
    private final String outputPath;
    boolean outprint = false;

    public ModelDataGenerator(DataModelDesc model, int nRows) {
        this(model, nRows, ResourceStore.getStore(model.getConfig()));
    }

    private ModelDataGenerator(DataModelDesc model, int nRows, ResourceStore outputStore) {
        this(model, nRows, outputStore, "/data");
    }

    private ModelDataGenerator(DataModelDesc model, int nRows, ResourceStore outputStore, String outputPath) {
        this.model = model;
        this.targetRows = nRows;
        this.outputStore = outputStore;
        this.outputPath = outputPath;
    }

    public void generate() throws IOException {
        HashSet<TableDesc> generated = new HashSet<TableDesc>();
        LinkedHashSet<TableDesc> allTableDesc = new LinkedHashSet<TableDesc>();
        JoinTableDesc[] allTables = this.model.getJoinTables();
        for (int i = allTables.length - 1; i >= -1; --i) {
            TableDesc table = i == -1 ? this.model.getRootFactTable().getTableDesc() : allTables[i].getTableRef().getTableDesc();
            allTableDesc.add(table);
            if (generated.contains(table)) continue;
            logger.info(String.format("generating data for %s", table));
            boolean gen = this.generateTable(table);
            if (!gen) continue;
            generated.add(table);
        }
        this.generateDDL(allTableDesc);
    }

    private boolean generateTable(TableDesc table) throws IOException {
        TableGenConfig config = new TableGenConfig(table, this);
        if (!config.needGen) {
            return false;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter pout = new PrintWriter(new OutputStreamWriter((OutputStream)bout, "UTF-8"));
        this.generateTableInternal(table, config, pout);
        pout.close();
        bout.close();
        this.saveResource(bout.toByteArray(), this.path(table));
        return true;
    }

    private void generateTableInternal(TableDesc table, TableGenConfig config, PrintWriter out) throws IOException {
        int i;
        ColumnDesc[] columns = table.getColumns();
        ColumnGenerator[] colGens = new ColumnGenerator[columns.length];
        Iterator[] colIters = new Iterator[columns.length];
        int tableRows = (int)(config.rows > 1.0 ? config.rows : (double)this.targetRows * config.rows);
        tableRows = Math.max(1, tableRows);
        long seed = System.currentTimeMillis();
        for (i = 0; i < columns.length; ++i) {
            colGens[i] = new ColumnGenerator(columns[i], tableRows, this);
            colIters[i] = colGens[i].generate(seed);
        }
        for (i = 0; i < tableRows; ++i) {
            for (int c = 0; c < columns.length; ++c) {
                String v;
                if (c > 0) {
                    out.print(",");
                }
                Preconditions.checkState(((v = (String)colIters[c].next()) == null || !v.contains(",") ? 1 : 0) != 0);
                out.print(v);
            }
            out.print("\n");
        }
    }

    private void generateDDL(Set<TableDesc> tables) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter pout = new PrintWriter(new OutputStreamWriter((OutputStream)bout, "UTF-8"));
        this.generateDatabaseDDL(tables, pout);
        this.generateCreateTableDDL(tables, pout);
        this.generateLoadDataDDL(tables, pout);
        pout.close();
        bout.close();
        this.saveResource(bout.toByteArray(), this.path(this.model));
    }

    private void generateDatabaseDDL(Set<TableDesc> tables, PrintWriter out) {
        HashSet<String> dbs = new HashSet<String>();
        for (TableDesc t : tables) {
            String db = t.getDatabase();
            if (StringUtils.isBlank((String)db) || "DEFAULT".equals(db)) continue;
            dbs.add(db);
        }
        for (String db : dbs) {
            out.print("CREATE DATABASE IF NOT EXISTS " + this.normHiveIdentifier(db) + ";\n");
        }
        out.print("\n");
    }

    private void generateCreateTableDDL(Set<TableDesc> tables, PrintWriter out) {
        for (TableDesc t : tables) {
            if (t.isView()) continue;
            out.print("DROP TABLE IF EXISTS " + this.normHiveIdentifier(t.getIdentity()) + ";\n");
            out.print("CREATE TABLE " + this.normHiveIdentifier(t.getIdentity()) + "(" + "\n");
            for (int i = 0; i < t.getColumns().length; ++i) {
                ColumnDesc col = t.getColumns()[i];
                out.print("    ");
                if (i > 0) {
                    out.print(",");
                }
                out.print(this.normHiveIdentifier(col.getName()) + " " + this.hiveType(col.getType()) + "\n");
            }
            out.print(")\n");
            out.print("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
            out.print("STORED AS TEXTFILE;\n");
            out.print("\n");
        }
    }

    private String normHiveIdentifier(String orig) {
        return "`" + orig + "`";
    }

    private String hiveType(DataType type) {
        String t = type.toString();
        if (t.startsWith("varchar")) {
            return "string";
        }
        if (t.startsWith("integer")) {
            return "int";
        }
        return t;
    }

    private void generateLoadDataDDL(Set<TableDesc> tables, PrintWriter out) {
        for (TableDesc t : tables) {
            if (t.isView()) {
                out.print("-- " + t.getIdentity() + " is view \n");
                continue;
            }
            out.print("LOAD DATA LOCAL INPATH '" + t.getIdentity() + ".csv' OVERWRITE INTO TABLE " + this.normHiveIdentifier(t.getIdentity()) + ";\n");
        }
    }

    public boolean existsInStore(TableDesc table) throws IOException {
        return this.outputStore.exists(this.path(table));
    }

    public boolean isPK(ColumnDesc col) {
        for (JoinTableDesc joinTable : this.model.getJoinTables()) {
            JoinDesc join = joinTable.getJoin();
            for (TblColRef pk : join.getPrimaryKeyColumns()) {
                if (!pk.getColumnDesc().equals(col)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getPkValuesIfIsFk(ColumnDesc fk) throws IOException {
        JoinTableDesc[] joinTables = this.model.getJoinTables();
        for (int i = 0; i < joinTables.length; ++i) {
            List<String> pkValues;
            JoinTableDesc joinTable = joinTables[i];
            ColumnDesc pk = this.findPk(joinTable, fk);
            if (pk == null || (pkValues = this.getPkValues(pk)) == null) continue;
            return pkValues;
        }
        return null;
    }

    private ColumnDesc findPk(JoinTableDesc joinTable, ColumnDesc fk) {
        TblColRef[] fkCols = joinTable.getJoin().getForeignKeyColumns();
        for (int i = 0; i < fkCols.length; ++i) {
            if (!fkCols[i].getColumnDesc().equals(fk)) continue;
            return joinTable.getJoin().getPrimaryKeyColumns()[i].getColumnDesc();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPkValues(ColumnDesc pk) throws IOException {
        if (!this.existsInStore(pk.getTable())) {
            return null;
        }
        ArrayList<String> r = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.outputStore.getResource((String)this.path((TableDesc)pk.getTable())).inputStream, "UTF-8"));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                r.add(line.split(",")[pk.getZeroBasedIndex()]);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return r;
    }

    private void saveResource(byte[] content, String path) throws IOException {
        System.out.println("Generated " + this.outputStore.getReadableResourcePath(path));
        if (this.outprint) {
            System.out.println(Bytes.toString(content));
        }
        this.outputStore.putResource(path, new ByteArrayInputStream(content), System.currentTimeMillis());
    }

    private String path(TableDesc table) {
        return this.outputPath + "/" + table.getIdentity() + ".csv";
    }

    private String path(DataModelDesc model) {
        return this.outputPath + "/" + "ddl_" + model.getName() + ".sql";
    }

    public DataModelDesc getModle() {
        return this.model;
    }

    public static void main(String[] args) throws IOException {
        String modelName = args[0];
        int nRows = Integer.parseInt(args[1]);
        String outputDir = args.length > 2 ? args[2] : null;
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        DataModelDesc model = DataModelManager.getInstance(conf).getDataModelDesc(modelName);
        ResourceStore store = outputDir == null ? ResourceStore.getStore(conf) : ResourceStore.getStore(ModelDataGenerator.mockup(outputDir));
        ModelDataGenerator gen = new ModelDataGenerator(model, nRows, store);
        gen.generate();
    }

    private static KylinConfig mockup(String outputDir) {
        KylinConfig mockup = KylinConfig.createKylinConfig(KylinConfig.getInstanceFromEnv());
        mockup.setMetadataUrl(new File(outputDir).getAbsolutePath());
        return mockup;
    }
}

