/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;

public class SQLDigestUtil {
    public static <F, T> T appendTsFilterToExecute(SQLDigest sqlDigest, TblColRef partitionColRef, Range<Long> tsRange, Function<F, T> action) {
        TupleFilter originalFilter = sqlDigest.filter;
        sqlDigest.filter = SQLDigestUtil.createFilterForRealtime(originalFilter, partitionColRef, tsRange);
        boolean addFilterColumn = false;
        boolean addAllColumn = false;
        if (!sqlDigest.filterColumns.contains(partitionColRef)) {
            sqlDigest.filterColumns.add(partitionColRef);
            addFilterColumn = true;
        }
        if (!sqlDigest.allColumns.contains(partitionColRef)) {
            sqlDigest.allColumns.add(partitionColRef);
            addAllColumn = true;
        }
        Object ret = action.apply(null);
        sqlDigest.filter = originalFilter;
        if (addFilterColumn) {
            sqlDigest.filterColumns.remove(partitionColRef);
        }
        if (addAllColumn) {
            sqlDigest.allColumns.remove(partitionColRef);
        }
        return (T)ret;
    }

    private static String formatTimeStr(DataType type, long ts) {
        String ret;
        if (type == DataType.getType("date")) {
            ret = DateFormat.formatToDateStr(ts);
        } else if (type == DataType.getType("long")) {
            ret = String.valueOf(ts);
        } else {
            throw new IllegalArgumentException("Illegal type for partition column " + type);
        }
        return ret;
    }

    private static TupleFilter createFilterForRealtime(TupleFilter originFilter, TblColRef partitionColRef, Range<Long> tsRange) {
        ConstantTupleFilter constantTupleFilter;
        ColumnTupleFilter columnTupleFilter;
        DataType type = partitionColRef.getColumnDesc().getType();
        CompareTupleFilter startFilter = null;
        CompareTupleFilter endFilter = null;
        if (tsRange.hasLowerBound()) {
            String startTimeStr = SQLDigestUtil.formatTimeStr(type, (Long)tsRange.lowerEndpoint());
            startFilter = tsRange.lowerBoundType() == BoundType.CLOSED ? new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GTE) : new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GT);
            columnTupleFilter = new ColumnTupleFilter(partitionColRef);
            constantTupleFilter = new ConstantTupleFilter(startTimeStr);
            startFilter.addChild(columnTupleFilter);
            startFilter.addChild(constantTupleFilter);
        }
        if (tsRange.hasUpperBound()) {
            String endTimeStr = SQLDigestUtil.formatTimeStr(type, (Long)tsRange.upperEndpoint());
            endFilter = tsRange.upperBoundType() == BoundType.CLOSED ? new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LTE) : new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LT);
            columnTupleFilter = new ColumnTupleFilter(partitionColRef);
            constantTupleFilter = new ConstantTupleFilter(endTimeStr);
            endFilter.addChild(columnTupleFilter);
            endFilter.addChild(constantTupleFilter);
        }
        if (originFilter == null) {
            if (endFilter == null) {
                return startFilter;
            }
            if (startFilter == null) {
                return endFilter;
            }
        }
        LogicalTupleFilter logicalTupleFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
        if (originFilter != null) {
            logicalTupleFilter.addChild(originFilter);
        }
        if (startFilter != null) {
            logicalTupleFilter.addChild(startFilter);
        }
        if (endFilter != null) {
            logicalTupleFilter.addChild(endFilter);
        }
        return logicalTupleFilter;
    }
}

