/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PartitionDesc
implements Serializable {
    @JsonProperty(value="partition_date_column")
    private String partitionDateColumn;
    @JsonProperty(value="partition_time_column")
    private String partitionTimeColumn;
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_format")
    private String partitionDateFormat = "yyyy-MM-dd";
    @JsonProperty(value="partition_time_format")
    private String partitionTimeFormat = "HH:mm:ss";
    @JsonProperty(value="partition_type")
    private PartitionType partitionType = PartitionType.APPEND;
    @JsonProperty(value="partition_condition_builder")
    private String partitionConditionBuilderClz = DefaultPartitionConditionBuilder.class.getName();
    private TblColRef partitionDateColumnRef;
    private TblColRef partitionTimeColumnRef;
    private IPartitionConditionBuilder partitionConditionBuilder;

    public void init(DataModelDesc model) {
        if (StringUtils.isEmpty((CharSequence)this.partitionDateColumn)) {
            return;
        }
        this.partitionDateColumnRef = model.findColumn(this.partitionDateColumn);
        this.partitionDateColumn = this.partitionDateColumnRef.getIdentity();
        if (!StringUtils.isBlank((CharSequence)this.partitionTimeColumn)) {
            this.partitionTimeColumnRef = model.findColumn(this.partitionTimeColumn);
            this.partitionTimeColumn = this.partitionTimeColumnRef.getIdentity();
        }
        this.partitionConditionBuilder = (IPartitionConditionBuilder)ClassUtil.newInstance(this.partitionConditionBuilderClz);
    }

    public boolean partitionColumnIsYmdInt() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return (type.isInt() || type.isBigInt()) && DateFormat.isDatePattern(this.partitionDateFormat);
    }

    public boolean partitionColumnIsTimeMillis() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isBigInt() && !DateFormat.isDatePattern(this.partitionDateFormat);
    }

    public boolean isPartitioned() {
        return this.partitionDateColumnRef != null;
    }

    public String getPartitionDateColumn() {
        return this.partitionDateColumn;
    }

    public void setPartitionDateColumn(String partitionDateColumn) {
        this.partitionDateColumn = partitionDateColumn;
    }

    void setPartitionDateColumnRef(TblColRef partitionDateColumnRef) {
        this.partitionDateColumnRef = partitionDateColumnRef;
    }

    public String getPartitionTimeColumn() {
        return this.partitionTimeColumn;
    }

    public void setPartitionTimeColumn(String partitionTimeColumn) {
        this.partitionTimeColumn = partitionTimeColumn;
    }

    void setPartitionTimeColumnRef(TblColRef partitionTimeColumnRef) {
        this.partitionTimeColumnRef = partitionTimeColumnRef;
    }

    @Deprecated
    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    @Deprecated
    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public String getPartitionDateFormat() {
        return this.partitionDateFormat;
    }

    public void setPartitionDateFormat(String partitionDateFormat) {
        this.partitionDateFormat = partitionDateFormat;
    }

    public String getPartitionTimeFormat() {
        return this.partitionTimeFormat;
    }

    public void setPartitionTimeFormat(String partitionTimeFormat) {
        this.partitionTimeFormat = partitionTimeFormat;
    }

    public PartitionType getCubePartitionType() {
        return this.partitionType;
    }

    public void setCubePartitionType(PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public String getPartitionConditionBuilderClz() {
        return this.partitionConditionBuilderClz;
    }

    public void setPartitionConditionBuilderClz(String partitionConditionBuilderClz) {
        this.partitionConditionBuilderClz = partitionConditionBuilderClz;
    }

    public IPartitionConditionBuilder getPartitionConditionBuilder() {
        return this.partitionConditionBuilder;
    }

    public TblColRef getPartitionDateColumnRef() {
        return this.partitionDateColumnRef;
    }

    public TblColRef getPartitionTimeColumnRef() {
        return this.partitionTimeColumnRef;
    }

    public static PartitionDesc getCopyOf(PartitionDesc orig) {
        PartitionDesc ret = new PartitionDesc();
        ret.partitionDateColumn = orig.partitionDateColumn;
        ret.partitionTimeColumn = orig.partitionTimeColumn;
        ret.partitionDateStart = orig.partitionDateStart;
        ret.partitionDateFormat = orig.partitionDateFormat;
        ret.partitionTimeFormat = orig.partitionTimeFormat;
        ret.partitionType = orig.partitionType;
        ret.partitionConditionBuilderClz = orig.partitionConditionBuilderClz;
        return ret;
    }

    public static class YearMonthDayPartitionConditionBuilder
    implements IPartitionConditionBuilder {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange) {
            long startInclusive = (Long)segRange.start.v;
            long endExclusive = (Long)segRange.end.v;
            TblColRef partitionColumn = partDesc.getPartitionDateColumnRef();
            String tableAlias = partitionColumn.getTableAlias();
            String concatField = String.format("CONCAT(%s.YEAR,'-',%s.MONTH,'-',%s.DAY)", tableAlias, tableAlias, tableAlias);
            StringBuilder builder = new StringBuilder();
            if (startInclusive > 0L) {
                builder.append(concatField + " >= '" + DateFormat.formatToDateStr(startInclusive) + "' ");
                builder.append("AND ");
            }
            builder.append(concatField + " < '" + DateFormat.formatToDateStr(endExclusive) + "'");
            return builder.toString();
        }
    }

    public static class DefaultPartitionConditionBuilder
    implements IPartitionConditionBuilder,
    Serializable {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange) {
            long startInclusive = (Long)segRange.start.v;
            long endExclusive = (Long)segRange.end.v;
            TblColRef partitionDateColumn = partDesc.getPartitionDateColumnRef();
            TblColRef partitionTimeColumn = partDesc.getPartitionTimeColumnRef();
            StringBuilder builder = new StringBuilder();
            if (partDesc.partitionColumnIsYmdInt()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmdInt(builder, partitionDateColumn, startInclusive, endExclusive);
            } else if (partDesc.partitionColumnIsTimeMillis()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsTimeMillis(builder, partitionDateColumn, startInclusive, endExclusive);
            } else if (partitionDateColumn != null && partitionTimeColumn == null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionDateColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat());
            } else if (partitionDateColumn == null && partitionTimeColumn != null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionTimeColumn, startInclusive, endExclusive, partDesc.getPartitionTimeFormat());
            } else if (partitionDateColumn != null && partitionTimeColumn != null) {
                DefaultPartitionConditionBuilder.buildMultipleColumnRangeCondition(builder, partitionDateColumn, partitionTimeColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat(), partDesc.getPartitionTimeFormat());
            }
            return builder.toString();
        }

        private static void buildSingleColumnRangeCondAsTimeMillis(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getIdentity();
            builder.append(partitionColumnName + " >= " + startInclusive);
            builder.append(" AND ");
            builder.append(partitionColumnName + " < " + endExclusive);
        }

        private static void buildSingleColumnRangeCondAsYmdInt(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getIdentity();
            builder.append(partitionColumnName + " >= " + DateFormat.formatToDateStr(startInclusive, "yyyyMMdd"));
            builder.append(" AND ");
            builder.append(partitionColumnName + " < " + DateFormat.formatToDateStr(endExclusive, "yyyyMMdd"));
        }

        private static void buildSingleColumnRangeCondition(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat) {
            String partitionColumnName = partitionColumn.getIdentity();
            if (endExclusive <= startInclusive) {
                builder.append("1=1");
                return;
            }
            String startInc = null;
            String endInc = null;
            if (StringUtils.isBlank((CharSequence)partitionColumnDateFormat)) {
                startInc = String.valueOf(startInclusive);
                endInc = String.valueOf(endExclusive);
            } else {
                startInc = DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat);
                endInc = DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat);
            }
            builder.append(partitionColumnName + " >= '" + startInc + "'");
            builder.append(" AND ");
            builder.append(partitionColumnName + " < '" + endInc + "'");
        }

        private static void buildMultipleColumnRangeCondition(StringBuilder builder, TblColRef partitionDateColumn, TblColRef partitionTimeColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat, String partitionColumnTimeFormat) {
            String partitionDateColumnName = partitionDateColumn.getIdentity();
            String partitionTimeColumnName = partitionTimeColumn.getIdentity();
            builder.append("(");
            builder.append("(");
            builder.append(partitionDateColumnName + " = '" + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + "'").append(" AND ").append(partitionTimeColumnName + " >= '" + DateFormat.formatToDateStr(startInclusive, partitionColumnTimeFormat) + "'");
            builder.append(")");
            builder.append(" OR ");
            builder.append("(");
            builder.append(partitionDateColumnName + " > '" + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + "'");
            builder.append(")");
            builder.append(")");
            builder.append(" AND ");
            builder.append("(");
            builder.append("(");
            builder.append(partitionDateColumnName + " = '" + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + "'").append(" AND ").append(partitionTimeColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnTimeFormat) + "'");
            builder.append(")");
            builder.append(" OR ");
            builder.append("(");
            builder.append(partitionDateColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + "'");
            builder.append(")");
            builder.append(")");
        }
    }

    public static interface IPartitionConditionBuilder {
        public String buildDateRangeCondition(PartitionDesc var1, ISegment var2, SegmentRange var3);
    }

    public static enum PartitionType implements Serializable
    {
        APPEND,
        UPDATE_INSERT;

    }
}

