/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JoinDesc
implements Serializable {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="primary_key")
    private String[] primaryKey;
    @JsonProperty(value="foreign_key")
    private String[] foreignKey;
    private TblColRef[] primaryKeyColumns;
    private TblColRef[] foreignKeyColumns;

    public void swapPKFK() {
        String[] t = this.primaryKey;
        this.primaryKey = this.foreignKey;
        this.foreignKey = t;
        TblColRef[] tt = this.primaryKeyColumns;
        this.primaryKeyColumns = this.foreignKeyColumns;
        this.foreignKeyColumns = tt;
    }

    public boolean isInnerJoin() {
        return "INNER".equalsIgnoreCase(this.type);
    }

    public boolean isLeftJoin() {
        return "LEFT".equalsIgnoreCase(this.type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String[] primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String[] getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String[] foreignKey) {
        this.foreignKey = foreignKey;
    }

    public TblColRef[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(TblColRef[] primaryKeyColumns) {
        this.checkSameTable(primaryKeyColumns);
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public TblColRef[] getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public void setForeignKeyColumns(TblColRef[] foreignKeyColumns) {
        this.checkSameTable(this.primaryKeyColumns);
        this.foreignKeyColumns = foreignKeyColumns;
    }

    private void checkSameTable(TblColRef[] cols) {
        if (cols == null || cols.length == 0) {
            return;
        }
        TableRef tableRef = cols[0].getTableRef();
        for (int i = 1; i < cols.length; ++i) {
            Preconditions.checkState((tableRef == cols[i].getTableRef() ? 1 : 0) != 0);
        }
    }

    public TableRef getPKSide() {
        return this.primaryKeyColumns[0].getTableRef();
    }

    public TableRef getFKSide() {
        return this.foreignKeyColumns[0].getTableRef();
    }

    public void sortByFK() {
        Preconditions.checkState((this.primaryKey.length == this.foreignKey.length && this.primaryKey.length == this.primaryKeyColumns.length && this.foreignKey.length == this.foreignKeyColumns.length ? 1 : 0) != 0);
        boolean cont = true;
        int n = this.foreignKey.length;
        for (int i = 0; i < n - 1 && cont; ++i) {
            cont = false;
            for (int j = 0; j < n - 1 - i; ++j) {
                int jj = j + 1;
                if (this.foreignKey[j].compareTo(this.foreignKey[jj]) <= 0) continue;
                this.swap(this.foreignKey, j, jj);
                this.swap(this.primaryKey, j, jj);
                this.swap(this.foreignKeyColumns, j, jj);
                this.swap(this.primaryKeyColumns, j, jj);
                cont = true;
            }
        }
    }

    private void swap(String[] arr, int j, int jj) {
        String tmp = arr[j];
        arr[j] = arr[jj];
        arr[jj] = tmp;
    }

    private void swap(TblColRef[] arr, int j, int jj) {
        TblColRef tmp = arr[j];
        arr[j] = arr[jj];
        arr[jj] = tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.primaryKeyColumns);
        result = 31 * result + Arrays.hashCode(this.foreignKeyColumns);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinDesc other = (JoinDesc)obj;
        if (!Arrays.equals(this.foreignKey, other.foreignKey)) {
            return false;
        }
        if (!Arrays.equals(this.primaryKey, other.primaryKey)) {
            return false;
        }
        if (!Arrays.equals(this.foreignKeyColumns, other.foreignKeyColumns)) {
            return false;
        }
        if (!Arrays.equals(this.primaryKeyColumns, other.primaryKeyColumns)) {
            return false;
        }
        return this.type.equalsIgnoreCase(other.getType());
    }

    public String toString() {
        return "JoinDesc [type=" + this.type + ", primary_key=" + Arrays.toString(this.primaryKey) + ", foreign_key=" + Arrays.toString(this.foreignKey) + "]";
    }
}

