/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.FunctionTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.function.BuiltInMethod;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInFunctionTupleFilter
extends FunctionTupleFilter {
    public static final Logger logger = LoggerFactory.getLogger(BuiltInFunctionTupleFilter.class);
    protected String name;
    protected TupleFilter columnContainerFilter;
    protected ConstantTupleFilter constantTupleFilter;
    protected int colPosition;
    protected int constantPosition;
    protected Method method;
    protected List<Serializable> methodParams = Lists.newArrayList();
    protected boolean isValidFunc = false;
    protected boolean isReversed = false;
    static final Map<String, String> converters = Maps.newHashMap();

    public BuiltInFunctionTupleFilter(String name) {
        this(name, null);
    }

    public BuiltInFunctionTupleFilter(String name, TupleFilter.FilterOperatorEnum filterOperatorEnum) {
        super(Lists.newArrayList(), filterOperatorEnum == null ? TupleFilter.FilterOperatorEnum.FUNCTION : filterOperatorEnum);
        if (name != null) {
            this.name = name.toUpperCase();
            this.initMethod();
        }
    }

    public String getName() {
        return this.name;
    }

    public ConstantTupleFilter getConstantTupleFilter() {
        return this.constantTupleFilter;
    }

    public TupleFilter getColumnContainerFilter() {
        return this.columnContainerFilter;
    }

    public TblColRef getColumn() {
        if (this.columnContainerFilter == null) {
            return null;
        }
        if (this.columnContainerFilter instanceof ColumnTupleFilter) {
            return ((ColumnTupleFilter)this.columnContainerFilter).getColumn();
        }
        if (this.columnContainerFilter instanceof BuiltInFunctionTupleFilter) {
            return ((BuiltInFunctionTupleFilter)this.columnContainerFilter).getColumn();
        }
        throw new UnsupportedOperationException("Wrong type TupleFilter in FunctionTupleFilter.");
    }

    public Object invokeFunction(Object input) throws InvocationTargetException, IllegalAccessException {
        if (this.columnContainerFilter instanceof ColumnTupleFilter) {
            this.methodParams.set(this.colPosition, (Serializable)input);
        } else if (this.columnContainerFilter instanceof BuiltInFunctionTupleFilter) {
            this.methodParams.set(this.colPosition, (Serializable)((BuiltInFunctionTupleFilter)this.columnContainerFilter).invokeFunction(input));
        }
        return this.method.invoke(null, this.methodParams.toArray());
    }

    public boolean isValid() {
        return this.isValidFunc && this.method != null && this.methodParams.size() == this.children.size();
    }

    @Override
    public TupleFilter reverse() {
        this.isReversed = !this.isReversed;
        return this;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public void setReversed(boolean reversed) {
        this.isReversed = reversed;
    }

    @Override
    public void addChild(TupleFilter child) {
        if (child instanceof ColumnTupleFilter || child instanceof BuiltInFunctionTupleFilter) {
            this.columnContainerFilter = child;
            this.colPosition = this.methodParams.size();
            this.methodParams.add(null);
        } else if (child instanceof ConstantTupleFilter) {
            this.constantTupleFilter = (ConstantTupleFilter)child;
            Serializable constVal = (Serializable)child.getValues().iterator().next();
            try {
                this.constantPosition = this.methodParams.size();
                Class clazz = Primitives.wrap(this.method.getParameterTypes()[this.methodParams.size()]);
                if (!Primitives.isWrapperType((Class)clazz)) {
                    this.methodParams.add(constVal);
                } else {
                    this.methodParams.add((Serializable)clazz.cast(clazz.getDeclaredMethod("valueOf", String.class).invoke(null, constVal)));
                }
            }
            catch (Exception e) {
                logger.warn("Reflection failed for methodParams. ", (Throwable)e);
                this.isValidFunc = false;
            }
        }
        super.addChild(child);
    }

    @Override
    public boolean isEvaluable() {
        return false;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        throw new UnsupportedOperationException("Function filter cannot be evaluated immediately");
    }

    @Override
    public Collection<?> getValues() {
        throw new UnsupportedOperationException("Function filter cannot be evaluated immediately");
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        BytesUtil.writeUTFString(this.name, buffer);
        buffer.put((byte)(this.isReversed ? 1 : 0));
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.name = BytesUtil.readUTFString(buffer);
        this.isReversed = buffer.get() != 0;
        this.initMethod();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isReversed) {
            sb.append("NOT ");
        }
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < this.methodParams.size(); ++i) {
            if (this.colPosition == i) {
                sb.append(this.columnContainerFilter);
            } else {
                sb.append(this.methodParams.get(i));
            }
            if (i >= this.methodParams.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    protected void initMethod() {
        String operator;
        String string = operator = BuiltInMethod.MAP.containsKey((Object)this.name) ? this.name : converters.get(this.name);
        if (operator != null) {
            this.method = ((BuiltInMethod)((Object)BuiltInMethod.MAP.get((Object)operator))).method;
            this.isValidFunc = true;
        }
    }

    static {
        converters.put("||", "CONCAT");
    }
}

