/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.acl.TableACL;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableACLManager {
    private static final Logger logger = LoggerFactory.getLogger(TableACLManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<TableACL> tableACLMap;
    private CachedCrudAssist<TableACL> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static TableACLManager getInstance(KylinConfig config) {
        return config.getManager(TableACLManager.class);
    }

    static TableACLManager newInstance(KylinConfig config) throws IOException {
        return new TableACLManager(config);
    }

    public TableACLManager(KylinConfig config) throws IOException {
        logger.info("Initializing TableACLManager with config " + config);
        this.config = config;
        this.tableACLMap = new CaseInsensitiveStringCache(config, "table_acl");
        this.crud = new CachedCrudAssist<TableACL>(this.getStore(), "/table_acl", "", TableACL.class, this.tableACLMap){

            @Override
            protected TableACL initEntityAfterReload(TableACL acl, String resourceName) {
                acl.init(resourceName);
                return acl;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(config).registerListener(new TableACLSyncListener(), "table_acl");
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public TableACL getTableACLByCache(String project) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            TableACL tableACL = (TableACL)this.tableACLMap.get(project);
            if (tableACL == null) {
                TableACL tableACL2 = this.newTableACL(project);
                return tableACL2;
            }
            TableACL tableACL3 = tableACL;
            return tableACL3;
        }
    }

    public void addTableACL(String project, String name, String table, String type) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            TableACL tableACL = this.loadTableACL(project).add(name, table, type);
            this.crud.save(tableACL);
        }
    }

    public void deleteTableACL(String project, String name, String table, String type) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            TableACL tableACL = this.loadTableACL(project).delete(name, table, type);
            this.crud.save(tableACL);
        }
    }

    public void deleteTableACL(String project, String name, String type) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            TableACL tableACL = this.loadTableACL(project).delete(name, type);
            this.crud.save(tableACL);
        }
    }

    public void deleteTableACLByTbl(String project, String table) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            TableACL tableACL = this.loadTableACL(project).deleteByTbl(table);
            this.crud.save(tableACL);
        }
    }

    private TableACL loadTableACL(String project) throws IOException {
        TableACL acl = this.crud.reload(project);
        if (acl == null) {
            acl = this.newTableACL(project);
        }
        return acl;
    }

    private TableACL newTableACL(String project) {
        TableACL acl = new TableACL();
        acl.updateRandomUuid();
        acl.init(project);
        return acl;
    }

    private class TableACLSyncListener
    extends Broadcaster.Listener {
        private TableACLSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = TableACLManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    TableACLManager.this.tableACLMap.removeLocal(cacheKey);
                } else {
                    TableACLManager.this.crud.reloadQuietly(cacheKey);
                }
            }
            broadcaster.notifyProjectACLUpdate(cacheKey);
        }
    }
}

