/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class BitmapSerializer
extends DataTypeSerializer<BitmapCounter> {
    private static final BitmapCounterFactory factory = RoaringBitmapCounterFactory.INSTANCE;
    private static final BitmapCounter DELEGATE = factory.newBitmap();
    private static final int IS_RESULT_FLAG = 1;
    private static final int RESULT_SIZE = 12;

    public BitmapSerializer(DataType type) {
    }

    @Override
    public void serialize(BitmapCounter value, ByteBuffer out) {
        try {
            value.write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BitmapCounter deserialize(ByteBuffer in) {
        try {
            if (this.peekLength(in) == 12) {
                int flag = in.getInt();
                return factory.newBitmap(in.getLong());
            }
            return factory.newBitmap(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int peekLength(ByteBuffer in) {
        ByteBuffer buffer = in.slice();
        if (buffer.getInt(0) == 1) {
            return 12;
        }
        return DELEGATE.peekLength(in);
    }

    @Override
    public int maxLength() {
        return 0x800000;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8192;
    }

    @Override
    public boolean supportDirectReturnResult() {
        return true;
    }

    @Override
    public ByteBuffer getFinalResult(ByteBuffer in) {
        ByteBuffer out = ByteBuffer.allocate(12);
        try {
            BitmapCounter counter = factory.newBitmap(in);
            out.putInt(1);
            out.putLong(counter.getCount());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        out.flip();
        return out;
    }
}

