/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SnapshotTable
extends RootPersistentEntity
implements IReadableTable {
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="signature")
    private IReadableTable.TableSignature signature;
    @JsonProperty(value="useDictionary")
    private boolean useDictionary;
    private ArrayList<int[]> rowIndices;
    private Dictionary<String> dict;
    private static String NULL_STR;

    public SnapshotTable() {
        try {
            NULL_STR = new String(new byte[]{0, 9, 127, -1}, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    SnapshotTable(IReadableTable table, String tableName) throws IOException {
        try {
            NULL_STR = new String(new byte[]{0, 9, 127, -1}, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tableName = tableName;
        this.signature = table.getSignature();
        this.useDictionary = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeSnapshot(IReadableTable table, TableDesc tableDesc) throws IOException {
        this.signature = table.getSignature();
        int maxIndex = tableDesc.getMaxColumnIndex();
        TrieDictionaryBuilder<String> b = new TrieDictionaryBuilder<String>(new StringBytesConverter());
        IReadableTable.TableReader reader = table.getReader();
        try {
            while (reader.next()) {
                Object[] row = reader.getRow();
                if (row.length <= maxIndex) {
                    throw new IllegalStateException("Bad hive table row, " + tableDesc + " expect " + (maxIndex + 1) + " columns, but got " + Arrays.toString(row));
                }
                for (ColumnDesc column : tableDesc.getColumns()) {
                    Object cell = row[column.getZeroBasedIndex()];
                    if (cell == null) continue;
                    b.addValue((String)cell);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.dict = b.build(0);
        ArrayList<int[]> allRowIndices = new ArrayList<int[]>();
        reader = table.getReader();
        try {
            while (reader.next()) {
                String[] row = reader.getRow();
                int[] rowIndex = new int[tableDesc.getColumnCount()];
                for (ColumnDesc column : tableDesc.getColumns()) {
                    rowIndex[column.getZeroBasedIndex()] = this.dict.getIdFromValue(row[column.getZeroBasedIndex()]);
                }
                allRowIndices.add(rowIndex);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.rowIndices = allRowIndices;
    }

    public String getResourcePath() {
        return this.getResourceDir() + "/" + this.uuid + ".snapshot";
    }

    public String getResourceDir() {
        if (Strings.isNullOrEmpty((String)this.tableName)) {
            return this.getOldResourceDir();
        }
        return "/table_snapshot/" + this.tableName;
    }

    private String getOldResourceDir() {
        return "/table_snapshot/" + new File(this.signature.getPath()).getName();
    }

    @Override
    public IReadableTable.TableReader getReader() throws IOException {
        return new IReadableTable.TableReader(){
            int i = -1;

            @Override
            public boolean next() throws IOException {
                ++this.i;
                return this.i < SnapshotTable.this.rowIndices.size();
            }

            @Override
            public String[] getRow() {
                int[] rowIndex = (int[])SnapshotTable.this.rowIndices.get(this.i);
                String[] row = new String[rowIndex.length];
                for (int x = 0; x < row.length; ++x) {
                    row[x] = (String)SnapshotTable.this.dict.getValueFromId(rowIndex[x]);
                }
                return row;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public IReadableTable.TableSignature getSignature() throws IOException {
        return this.signature;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public int hashCode() {
        int[] parts = new int[this.rowIndices.size()];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = Arrays.hashCode(this.rowIndices.get(i));
        }
        return Arrays.hashCode(parts);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SnapshotTable)) {
            return false;
        }
        SnapshotTable that = (SnapshotTable)o;
        if (!this.dict.equals(that.dict)) {
            return false;
        }
        if (this.rowIndices.size() != that.rowIndices.size()) {
            return false;
        }
        for (int i = 0; i < this.rowIndices.size(); ++i) {
            if (ArrayUtils.isEquals((Object)this.rowIndices.get(i), (Object)that.rowIndices.get(i))) continue;
            return false;
        }
        return true;
    }

    void writeData(DataOutput out) throws IOException {
        block6: {
            out.writeInt(this.rowIndices.size());
            if (this.rowIndices.size() <= 0) break block6;
            int n = this.rowIndices.get(0).length;
            out.writeInt(n);
            if (this.useDictionary) {
                this.dict.write(out);
                for (int i = 0; i < this.rowIndices.size(); ++i) {
                    int[] row = this.rowIndices.get(i);
                    for (int j = 0; j < n; ++j) {
                        out.writeInt(row[j]);
                    }
                }
            } else {
                for (int i = 0; i < this.rowIndices.size(); ++i) {
                    int[] row = this.rowIndices.get(i);
                    for (int j = 0; j < n; ++j) {
                        out.writeUTF(this.dict.getValueFromId(row[j]) == null ? NULL_STR : this.dict.getValueFromId(row[j]));
                    }
                }
            }
        }
    }

    void readData(DataInput in) throws IOException {
        int rowNum = in.readInt();
        if (rowNum > 0) {
            int n = in.readInt();
            this.rowIndices = new ArrayList(rowNum);
            if (this.useDictionary) {
                this.dict = new TrieDictionary<String>();
                this.dict.readFields(in);
                for (int i = 0; i < rowNum; ++i) {
                    int[] row = new int[n];
                    this.rowIndices.add(row);
                    for (int j = 0; j < n; ++j) {
                        row[j] = in.readInt();
                    }
                }
            } else {
                ArrayList<String[]> rows = new ArrayList<String[]>(rowNum);
                TrieDictionaryBuilder<String> b = new TrieDictionaryBuilder<String>(new StringBytesConverter());
                for (int i = 0; i < rowNum; ++i) {
                    String[] row = new String[n];
                    rows.add(row);
                    for (int j = 0; j < n; ++j) {
                        row[j] = in.readUTF();
                        if (row[j].equals(NULL_STR)) {
                            row[j] = null;
                        }
                        b.addValue(row[j]);
                    }
                }
                this.dict = b.build(0);
                for (String[] row : rows) {
                    int[] rowIndex = new int[n];
                    for (int i = 0; i < n; ++i) {
                        rowIndex[i] = this.dict.getIdFromValue(row[i]);
                    }
                    this.rowIndices.add(rowIndex);
                }
            }
        } else {
            this.rowIndices = new ArrayList();
            this.dict = new TrieDictionary<String>();
        }
    }

    public int getRowCount() {
        return this.rowIndices.size();
    }
}

