/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import java.io.IOException;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.global.AppendTrieDictionaryBuilder;

public class SegmentAppendTrieDictBuilder
implements IDictionaryBuilder {
    private AppendTrieDictionaryBuilder builder;
    private int baseId;
    private String sourceColumn;

    @Override
    public void init(DictionaryInfo dictInfo, int baseId, String hdfsDir) throws IOException {
        this.sourceColumn = dictInfo.getSourceTable() + "." + dictInfo.getSourceColumn();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int maxEntriesPerSlice = config.getAppendDictEntrySize();
        if (hdfsDir == null) {
            hdfsDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        }
        String baseDir = hdfsDir + "resources/SegmentDict" + dictInfo.getResourceDir() + "/" + UUID.randomUUID().toString() + "_" + System.currentTimeMillis() + "/";
        this.builder = new AppendTrieDictionaryBuilder(baseDir, maxEntriesPerSlice, false);
        this.baseId = baseId;
    }

    @Override
    public boolean addValue(String value) {
        if (value == null) {
            return false;
        }
        try {
            this.builder.addValue(value);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Failed to create global dictionary on %s ", this.sourceColumn), e);
        }
        return true;
    }

    @Override
    public Dictionary<String> build() throws IOException {
        return this.builder.build(this.baseId);
    }
}

