/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.global.AppendDictNode;

public class AppendDictSlice {
    static final byte[] HEAD_MAGIC = new byte[]{65, 112, 112, 101, 99, 100, 84, 114, 105, 101, 68, 105, 99, 116};
    static final int HEAD_SIZE_I = HEAD_MAGIC.length;
    static final int BIT_IS_LAST_CHILD = 128;
    static final int BIT_IS_END_OF_VALUE = 64;
    private byte[] trieBytes;
    private transient int headSize;
    private transient int bodyLen;
    private transient int sizeChildOffset;
    private transient int nValues;
    private transient int sizeOfId;
    private transient long childOffsetMask;
    private transient int firstByteOffset;

    public AppendDictSlice(byte[] bytes) {
        this.trieBytes = bytes;
        this.init();
    }

    private void init() {
        if (BytesUtil.compareBytes(HEAD_MAGIC, 0, this.trieBytes, 0, HEAD_MAGIC.length) != 0) {
            throw new IllegalArgumentException("Wrong file type (magic does not match)");
        }
        try {
            DataInputStream headIn = new DataInputStream(new ByteArrayInputStream(this.trieBytes, HEAD_SIZE_I, this.trieBytes.length - HEAD_SIZE_I));
            this.headSize = headIn.readShort();
            this.bodyLen = headIn.readInt();
            this.nValues = headIn.readInt();
            this.sizeChildOffset = headIn.read();
            this.sizeOfId = headIn.read();
            this.childOffsetMask = 192L << (this.sizeChildOffset - 1) * 8 ^ 0xFFFFFFFFFFFFFFFFL;
            this.firstByteOffset = this.sizeChildOffset + 1;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static AppendDictSlice deserializeFrom(DataInput in) throws IOException {
        byte[] headPartial = new byte[HEAD_MAGIC.length + 2 + 4];
        in.readFully(headPartial);
        if (BytesUtil.compareBytes(HEAD_MAGIC, 0, headPartial, 0, HEAD_MAGIC.length) != 0) {
            throw new IllegalArgumentException("Wrong file type (magic does not match)");
        }
        DataInputStream headIn = new DataInputStream(new ByteArrayInputStream(headPartial, HEAD_SIZE_I, headPartial.length - HEAD_SIZE_I));
        short headSize = headIn.readShort();
        int bodyLen = headIn.readInt();
        headIn.close();
        byte[] all = new byte[headSize + bodyLen];
        System.arraycopy(headPartial, 0, all, 0, headPartial.length);
        in.readFully(all, headPartial.length, all.length - headPartial.length);
        return new AppendDictSlice(all);
    }

    public byte[] getFirstValue() {
        int nodeOffset = this.headSize;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        do {
            int valueLen = BytesUtil.readUnsigned(this.trieBytes, nodeOffset + this.firstByteOffset - 1, 1);
            bytes.write(this.trieBytes, nodeOffset + this.firstByteOffset, valueLen);
        } while (!this.checkFlag(nodeOffset, 64) && (nodeOffset = this.headSize + (int)(BytesUtil.readLong(this.trieBytes, nodeOffset, this.sizeChildOffset) & this.childOffsetMask)) != this.headSize);
        return bytes.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private int lookupSeqNoFromValue(int n, byte[] inp, int o, int inpEnd, int roundingFlag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getStructuredStatement(GotoStatement.java:116)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkFlag(int offset, int bit) {
        return (this.trieBytes[offset] & bit) > 0;
    }

    public int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
        int id = this.lookupSeqNoFromValue(this.headSize, value, offset, offset + len, roundingFlag);
        return id;
    }

    public AppendDictNode rebuildTrieTree() {
        return this.rebuildTrieTreeR(this.headSize, null);
    }

    private AppendDictNode rebuildTrieTreeR(int n, AppendDictNode parent) {
        AppendDictNode root = null;
        while (true) {
            int p = n + this.firstByteOffset;
            int childOffset = (int)(BytesUtil.readLong(this.trieBytes, n, this.sizeChildOffset) & this.childOffsetMask);
            int parLen = BytesUtil.readUnsigned(this.trieBytes, p - 1, 1);
            boolean isEndOfValue = this.checkFlag(n, 64);
            byte[] value = new byte[parLen];
            System.arraycopy(this.trieBytes, p, value, 0, parLen);
            AppendDictNode node = new AppendDictNode(value, isEndOfValue);
            if (isEndOfValue) {
                int id;
                node.id = id = BytesUtil.readUnsigned(this.trieBytes, p + parLen, this.sizeOfId);
            }
            if (parent == null) {
                root = node;
            } else {
                parent.addChild(node);
            }
            if (childOffset != 0) {
                this.rebuildTrieTreeR(childOffset + this.headSize, node);
            }
            if (this.checkFlag(n, 128)) break;
            n += this.firstByteOffset + parLen + (isEndOfValue ? this.sizeOfId : 0);
        }
        return root;
    }

    public boolean doCheck() {
        boolean isEndOfValue;
        int parLen;
        HashSet<Integer> parentSet = new HashSet<Integer>();
        boolean lastChild = false;
        for (int offset = this.headSize; offset < this.trieBytes.length; offset += this.firstByteOffset + parLen + (isEndOfValue ? this.sizeOfId : 0)) {
            if (lastChild) {
                boolean contained = parentSet.remove(offset - this.headSize);
                if (!contained) {
                    return false;
                }
                lastChild = false;
            }
            int p = offset + this.firstByteOffset;
            int childOffset = (int)(BytesUtil.readLong(this.trieBytes, offset, this.sizeChildOffset) & this.childOffsetMask);
            parLen = BytesUtil.readUnsigned(this.trieBytes, p - 1, 1);
            isEndOfValue = this.checkFlag(offset, 64);
            if (this.trieBytes.length < p + parLen) {
                return false;
            }
            if (isEndOfValue) {
                BytesUtil.readUnsigned(this.trieBytes, p + parLen, this.sizeOfId);
            }
            if (childOffset != 0) {
                parentSet.add(childOffset);
            }
            if (!this.checkFlag(offset, 128)) continue;
            lastChild = true;
        }
        return parentSet.isEmpty();
    }

    public String toString() {
        return String.format("DictSlice[firstValue=%s, values=%d, bytes=%d]", Bytes.toStringBinary(this.getFirstValue()), this.nValues, this.bodyLen);
    }

    public int hashCode() {
        return Arrays.hashCode(this.trieBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppendDictSlice)) {
            return false;
        }
        AppendDictSlice that = (AppendDictSlice)o;
        return Arrays.equals(this.trieBytes, that.trieBytes);
    }
}

