/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.util.ArrayList;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.dict.TrieDictionaryForest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieDictionaryForestBuilder<T> {
    public static int DEFAULT_MAX_TRIE_TREE_SIZE_MB = 500;
    private static final Logger logger = LoggerFactory.getLogger(TrieDictionaryForestBuilder.class);
    private BytesConverter<T> bytesConverter;
    private int curTreeSize = 0;
    private TrieDictionaryBuilder<T> trieBuilder;
    private ArrayList<TrieDictionary<T>> trees = new ArrayList();
    private ArrayList<ByteArray> valueDivide = new ArrayList();
    private ArrayList<Integer> accuOffset = new ArrayList();
    private ByteArray previousValue = null;
    private int baseId;
    private int curOffset;
    private int maxTrieTreeSize;
    private boolean isOrdered = true;

    public TrieDictionaryForestBuilder(BytesConverter<T> bytesConverter) {
        this(bytesConverter, 0);
    }

    public TrieDictionaryForestBuilder(BytesConverter<T> bytesConverter, int baseId) {
        this(bytesConverter, baseId, TrieDictionaryForestBuilder.getMaxTrieSizeInMB());
    }

    public TrieDictionaryForestBuilder(BytesConverter<T> bytesConverter, int baseId, int maxTrieTreeSizeMB) {
        this.bytesConverter = bytesConverter;
        this.trieBuilder = new TrieDictionaryBuilder<T>(bytesConverter);
        this.baseId = baseId;
        this.curOffset = 0;
        this.maxTrieTreeSize = maxTrieTreeSizeMB * 1024 * 1024;
    }

    public void addValue(T value) {
        if (value == null) {
            return;
        }
        byte[] valueBytes = this.bytesConverter.convertToBytes(value);
        this.addValue(valueBytes);
    }

    private void addValue(byte[] valueBytes) {
        ByteArray valueByteArray = new ByteArray(valueBytes);
        if (this.previousValue != null && this.isOrdered) {
            int comp = this.previousValue.compareTo(valueByteArray);
            if (comp == 0) {
                return;
            }
            if (comp > 0) {
                logger.info("values not in ascending order, previous '{}', current '{}'", (Object)this.previousValue, (Object)valueByteArray);
                this.isOrdered = false;
                if (this.trees.size() > 0) {
                    throw new IllegalStateException("Invalid input data. Unordered data cannot be split into multi trees");
                }
            }
        }
        this.previousValue = valueByteArray;
        this.trieBuilder.addValue(valueBytes);
        this.curTreeSize += valueBytes.length;
        if (this.curTreeSize >= this.maxTrieTreeSize && this.isOrdered) {
            TrieDictionary<T> tree = this.trieBuilder.build(0);
            this.addTree(tree);
            this.reset();
        }
    }

    public TrieDictionaryForest<T> build() {
        TrieDictionaryForest<T> forest;
        if (this.trieBuilder.isHasValue()) {
            TrieDictionary<T> tree = this.trieBuilder.build(0);
            this.addTree(tree);
            this.reset();
        }
        if ((forest = new TrieDictionaryForest<T>(this.trees, this.valueDivide, this.accuOffset, this.bytesConverter, this.baseId)).getTrees().size() > 1 && !this.isOrdered) {
            throw new IllegalStateException("Invalid input data. Unordered data can not be split into multi trees");
        }
        return forest;
    }

    public int getMaxTrieTreeSize() {
        return this.maxTrieTreeSize;
    }

    void setMaxTrieTreeSize(int maxTrieTreeSize) {
        this.maxTrieTreeSize = maxTrieTreeSize;
        logger.info("maxTrieSize is set to:" + maxTrieTreeSize + "B");
    }

    private void addTree(TrieDictionary<T> tree) {
        this.trees.add(tree);
        int minId = tree.getMinId();
        this.accuOffset.add(this.curOffset);
        byte[] valueBytes = tree.getValueBytesFromIdWithoutCache(minId);
        this.valueDivide.add(new ByteArray(valueBytes, 0, valueBytes.length));
        this.curOffset += tree.getMaxId() + 1;
    }

    private void reset() {
        this.curTreeSize = 0;
        this.trieBuilder = new TrieDictionaryBuilder<T>(this.bytesConverter);
    }

    public static int getMaxTrieSizeInMB() {
        KylinConfig config = null;
        try {
            config = KylinConfig.getInstanceFromEnv();
        }
        catch (RuntimeException e) {
            logger.info("cannot get KylinConfig from env.Use default setting:" + DEFAULT_MAX_TRIE_TREE_SIZE_MB + "MB");
        }
        int maxTrieTreeSizeMB = config != null ? config.getTrieDictionaryForestMaxTrieSizeMB() : DEFAULT_MAX_TRIE_TREE_SIZE_MB;
        return maxTrieTreeSizeMB;
    }
}

