/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RowKeyDesc
implements Serializable {
    @JsonProperty(value="rowkey_columns")
    private RowKeyColDesc[] rowkeyColumns;
    private long fullMask;
    private CubeDesc cubeDesc;
    private Map<TblColRef, RowKeyColDesc> columnMap;
    private Set<TblColRef> shardByColumns;
    private int[] columnsNeedIndex;

    public RowKeyColDesc[] getRowKeyColumns() {
        return this.rowkeyColumns;
    }

    public void setCubeDesc(CubeDesc cubeRef) {
        this.cubeDesc = cubeRef;
    }

    public int getColumnBitIndex(TblColRef col) {
        return this.getColDesc(col).getBitIndex();
    }

    public RowKeyColDesc getColDesc(TblColRef col) {
        RowKeyColDesc desc = this.columnMap.get(col);
        if (desc == null) {
            throw new NullPointerException("Column " + col + " does not exist in row key desc");
        }
        return desc;
    }

    public boolean isUseDictionary(TblColRef col) {
        return this.getColDesc(col).isUsingDictionary();
    }

    public Set<TblColRef> getShardByColumns() {
        return this.shardByColumns;
    }

    public void init(CubeDesc cubeDesc) {
        this.setCubeDesc(cubeDesc);
        this.buildRowKey();
        this.initColumnsNeedIndex();
    }

    private void initColumnsNeedIndex() {
        int[] tmp = new int[100];
        int x = 0;
        int n = this.rowkeyColumns.length;
        for (int i = 0; i < n; ++i) {
            if (!"true".equalsIgnoreCase(this.rowkeyColumns[i].getIndex()) || !this.rowkeyColumns[i].isUsingDictionary()) continue;
            tmp[x] = i;
            ++x;
        }
        this.columnsNeedIndex = ArrayUtils.subarray((int[])tmp, (int)0, (int)x);
    }

    public void setRowkeyColumns(RowKeyColDesc[] rowkeyColumns) {
        this.rowkeyColumns = rowkeyColumns;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("RowKeyColumns", (Object)Arrays.toString(this.rowkeyColumns)).toString();
    }

    private void buildRowKey() {
        int i;
        this.columnMap = new HashMap<TblColRef, RowKeyColDesc>();
        this.shardByColumns = new HashSet<TblColRef>();
        for (i = 0; i < this.rowkeyColumns.length; ++i) {
            RowKeyColDesc rowKeyColDesc = this.rowkeyColumns[i];
            rowKeyColDesc.init(this.rowkeyColumns.length - i - 1, this.cubeDesc);
            this.columnMap.put(rowKeyColDesc.getColRef(), rowKeyColDesc);
            if (!rowKeyColDesc.isShardBy()) continue;
            this.shardByColumns.add(rowKeyColDesc.getColRef());
        }
        this.fullMask = 0L;
        for (i = 0; i < this.rowkeyColumns.length; ++i) {
            int index = this.rowkeyColumns[i].getBitIndex();
            this.fullMask |= 1L << index;
        }
    }

    public long getFullMask() {
        return this.fullMask;
    }

    public int[] getColumnsNeedIndex() {
        return this.columnsNeedIndex;
    }
}

