/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeyDecoder {
    private final CubeDesc cubeDesc;
    private final RowKeyColumnIO colIO;
    private final RowKeySplitter rowKeySplitter;
    private Cuboid cuboid;
    private List<String> values;

    public RowKeyDecoder(CubeSegment cubeSegment) {
        this.cubeDesc = cubeSegment.getCubeDesc();
        this.rowKeySplitter = new RowKeySplitter(cubeSegment, 65, 255);
        this.colIO = new RowKeyColumnIO(cubeSegment.getDimensionEncodingMap());
        this.values = new ArrayList<String>();
    }

    public long decode(byte[] bytes) throws IOException {
        this.values.clear();
        long cuboidId = this.rowKeySplitter.split(bytes);
        this.initCuboid(cuboidId);
        SplittedBytes[] splits = this.rowKeySplitter.getSplitBuffers();
        int offset = this.rowKeySplitter.getBodySplitOffset();
        for (int i = 0; i < this.cuboid.getColumns().size(); ++i) {
            TblColRef col = this.cuboid.getColumns().get(i);
            this.collectValue(col, splits[offset].value, splits[offset].length);
            ++offset;
        }
        return cuboidId;
    }

    private void initCuboid(long cuboidID) {
        if (this.cuboid != null && this.cuboid.getId() == cuboidID) {
            return;
        }
        this.cuboid = Cuboid.findForMandatory(this.cubeDesc, cuboidID);
    }

    private void collectValue(TblColRef col, byte[] valueBytes, int length) throws IOException {
        String strValue = this.colIO.readColumnString(col, valueBytes, 0, length);
        this.values.add(strValue);
    }

    public RowKeySplitter getRowKeySplitter() {
        return this.rowKeySplitter;
    }

    public void setCuboid(Cuboid cuboid) {
        this.cuboid = cuboid;
    }

    public List<TblColRef> getColumns() {
        return this.cuboid.getColumns();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.cuboid.getId());
        for (String value : this.values) {
            buf.append(",");
            buf.append((Object)value);
        }
        return buf.toString();
    }
}

