/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.gridtable.GTRecord;

public class CompoundCuboidWriter
implements ICuboidWriter {
    private Iterable<ICuboidWriter> cuboidWriters;

    public CompoundCuboidWriter(Iterable<ICuboidWriter> cuboidWriters) {
        this.cuboidWriters = cuboidWriters;
    }

    @Override
    public void write(long cuboidId, GTRecord record) throws IOException {
        for (ICuboidWriter writer : this.cuboidWriters) {
            writer.write(cuboidId, record);
        }
    }

    @Override
    public void flush() throws IOException {
        for (ICuboidWriter writer : this.cuboidWriters) {
            writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (ICuboidWriter writer : this.cuboidWriters) {
            writer.close();
        }
    }
}

