/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic.lib;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Population;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.StoppingCondition;

public class FixedGenerationCount
implements StoppingCondition {
    private final int maxGenerations;
    private int numGenerations = 0;

    public FixedGenerationCount(int maxGenerations) throws NumberIsTooSmallException {
        if (maxGenerations <= 0) {
            throw new NumberIsTooSmallException((Number)maxGenerations, (Number)1, true);
        }
        this.maxGenerations = maxGenerations;
    }

    @Override
    public boolean isSatisfied(Population population) {
        if (this.numGenerations < this.maxGenerations) {
            ++this.numGenerations;
            return false;
        }
        return true;
    }

    public int getNumGenerations() {
        return this.numGenerations;
    }
}

