/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic.lib;

import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ListPopulation;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Population;

public class ElitisticListPopulation
extends ListPopulation {
    private double elitismRate = 0.9;

    public ElitisticListPopulation(List<Chromosome> chromosomes, int populationLimit, double elitismRate) throws NullArgumentException, NotPositiveException, NumberIsTooLargeException, OutOfRangeException {
        super(chromosomes, populationLimit);
        this.setElitismRate(elitismRate);
    }

    public ElitisticListPopulation(int populationLimit, double elitismRate) throws NotPositiveException, OutOfRangeException {
        super(populationLimit);
        this.setElitismRate(elitismRate);
    }

    @Override
    public Population nextGeneration() {
        int boundIndex;
        ElitisticListPopulation nextGeneration = new ElitisticListPopulation(this.getPopulationLimit(), this.getElitismRate());
        List<Chromosome> oldChromosomes = this.getChromosomeList();
        Collections.sort(oldChromosomes);
        for (int i = boundIndex = (int)FastMath.ceil((double)((1.0 - this.getElitismRate()) * (double)oldChromosomes.size())); i < oldChromosomes.size(); ++i) {
            nextGeneration.addChromosome(oldChromosomes.get(i));
        }
        return nextGeneration;
    }

    public double getElitismRate() {
        return this.elitismRate;
    }

    public void setElitismRate(double elitismRate) throws OutOfRangeException {
        if (elitismRate < 0.0 || elitismRate > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ELITISM_RATE, (Number)elitismRate, (Number)0, (Number)1);
        }
        this.elitismRate = elitismRate;
    }
}

