/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.CombinedStoppingCondition;
import org.apache.kylin.cube.cuboid.algorithm.generic.CuboidEncoder;
import org.apache.kylin.cube.cuboid.algorithm.generic.RouletteWheelSelection;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.BitsMutation;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ChromosomePair;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.CrossoverPolicy;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ElitisticListPopulation;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.FixedGenerationCount;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.MutationPolicy;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.OnePointCrossover;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Population;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.SelectionPolicy;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.StoppingCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlgorithm
extends AbstractRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    public static ThreadLocal<Random> RANDGEN = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(System.currentTimeMillis() * Thread.currentThread().getId());
        }
    };
    private final double crossoverRate = 0.9;
    private final double mutationRate = 0.001;
    private final int populationSize = 500;
    private final int maxPopulationSize = 510;
    private CrossoverPolicy crossoverPolicy = new OnePointCrossover();
    private MutationPolicy mutationPolicy = new BitsMutation();
    private SelectionPolicy selectionPolicy = new RouletteWheelSelection();
    private CuboidEncoder cuboidEncoder = new CuboidEncoder(this.getCuboidStats());
    private int generationsEvolved = 0;

    public GeneticAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        super(timeout, benefitPolicy, cuboidStats);
    }

    @Override
    public List<Long> recommend(double expansionRate) {
        double spaceLimit = this.getCuboidStats().getBaseCuboidSize() * expansionRate;
        return this.start(spaceLimit);
    }

    @Override
    public List<Long> start(double maxSpaceLimit) {
        logger.debug("Genetic Algorithm started.");
        this.getBenefitPolicy().initBeforeStart();
        double remainingSpace = maxSpaceLimit;
        for (Long mandatoryOne : this.getCuboidStats().getAllCuboidsForMandatory()) {
            if (this.getCuboidStats().getCuboidSize(mandatoryOne) == null) continue;
            remainingSpace -= this.getCuboidStats().getCuboidSize(mandatoryOne).doubleValue();
        }
        Population initial = this.initRandomPopulation(remainingSpace);
        ArrayList conditions = Lists.newArrayList();
        conditions.add(new FixedGenerationCount(550));
        CombinedStoppingCondition stopCondition = new CombinedStoppingCondition(conditions);
        Population current = this.evolve(initial, stopCondition);
        BitsChromosome chromosome = (BitsChromosome)current.getFittestChromosome();
        logger.debug("Genetic Algorithm finished.");
        ArrayList finalList = Lists.newArrayList();
        finalList.addAll(this.getCuboidStats().getAllCuboidsForMandatory());
        finalList.addAll(this.cuboidEncoder.toCuboidList(chromosome.getKey()));
        double totalSpace = 0.0;
        if (logger.isTraceEnabled()) {
            for (Long cuboid : finalList) {
                Double unitSpace = this.getCuboidStats().getCuboidSize(cuboid);
                if (unitSpace != null) {
                    logger.trace(String.format("cuboidId %d and Space: %f", cuboid, unitSpace));
                    totalSpace += unitSpace.doubleValue();
                    continue;
                }
                logger.trace(String.format("mandatory cuboidId %d", cuboid));
            }
            logger.trace("Total Space:" + totalSpace);
            logger.trace("Space Expansion Rate:" + totalSpace / this.getCuboidStats().getBaseCuboidSize());
        }
        return finalList;
    }

    protected Population initRandomPopulation(double maxSpaceLimit) {
        ArrayList chromosomeList = Lists.newArrayListWithCapacity((int)500);
        ArrayList cuboidsForSelection = Lists.newArrayList(this.getCuboidStats().getAllCuboidsForSelection());
        int selectionSize = cuboidsForSelection.size();
        while (chromosomeList.size() < 500) {
            BitSet bitSetForSelection = new BitSet(selectionSize);
            double totalSpace = 0.0;
            while (totalSpace < maxSpaceLimit) {
                int j = RANDGEN.get().nextInt(selectionSize);
                if (bitSetForSelection.get(j)) continue;
                totalSpace += this.getCuboidStats().getCuboidSize((Long)cuboidsForSelection.get(j)).doubleValue();
                bitSetForSelection.set(j);
            }
            BitsChromosome chromosome = new BitsChromosome(bitSetForSelection, this.getBenefitPolicy(), this.getCuboidStats(), maxSpaceLimit);
            chromosomeList.add(chromosome);
        }
        return new ElitisticListPopulation(chromosomeList, 510, 0.8);
    }

    protected Population evolve(Population initial, StoppingCondition condition) {
        Population current = initial;
        this.generationsEvolved = 0;
        while (!condition.isSatisfied(current) && !this.shouldCancel()) {
            current = this.nextGeneration(current);
            ++this.generationsEvolved;
            logger.trace("Generations evolved count:" + this.generationsEvolved);
        }
        return current;
    }

    protected Population nextGeneration(Population current) {
        Population nextGeneration = current.nextGeneration();
        while (nextGeneration.getPopulationSize() < nextGeneration.getPopulationLimit()) {
            ChromosomePair pair = this.getSelectionPolicy().select(current);
            if (RANDGEN.get().nextDouble() < this.getCrossoverRate()) {
                pair = this.getCrossoverPolicy().crossover(pair.getFirst(), pair.getSecond());
            }
            if (RANDGEN.get().nextDouble() < this.getMutationRate()) {
                pair = new ChromosomePair(this.getMutationPolicy().mutate(pair.getFirst()), this.getMutationPolicy().mutate(pair.getSecond()));
            }
            nextGeneration.addChromosome(pair.getFirst());
            if (nextGeneration.getPopulationSize() >= nextGeneration.getPopulationLimit()) continue;
            nextGeneration.addChromosome(pair.getSecond());
        }
        return nextGeneration;
    }

    public CrossoverPolicy getCrossoverPolicy() {
        return this.crossoverPolicy;
    }

    public double getCrossoverRate() {
        return 0.9;
    }

    public MutationPolicy getMutationPolicy() {
        return this.mutationPolicy;
    }

    public double getMutationRate() {
        return 0.001;
    }

    public SelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public int getGenerationsEvolved() {
        return this.generationsEvolved;
    }
}

