/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.cube.cuboid.algorithm.generic.CuboidEncoder;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Chromosome;

public class BitsChromosome
extends Chromosome {
    private BitSet key;
    private int length;
    private BenefitPolicy benefitPolicy;
    private CuboidStats cuboidStats;
    private CuboidEncoder cuboidEncoder;
    private double spaceLimit;
    private double spaceCost;
    private double fitness = -1.0;

    public BitsChromosome(BitSet key, BenefitPolicy benefitPolicy, CuboidStats cuboidStats, double spaceLimit) {
        this.key = key;
        this.length = cuboidStats.getAllCuboidsForSelection().size();
        this.benefitPolicy = benefitPolicy.getInstance();
        this.cuboidStats = cuboidStats;
        this.cuboidEncoder = new CuboidEncoder(cuboidStats);
        this.spaceLimit = spaceLimit;
        this.initSpaceCost();
    }

    public BitsChromosome newBitsChromosome(BitSet newkey) {
        return new BitsChromosome(newkey, this.benefitPolicy, this.cuboidStats, this.spaceLimit);
    }

    private void initSpaceCost() {
        this.spaceCost = 0.0;
        List<Long> remainingCuboids = this.cuboidEncoder.toCuboidList(this.key);
        for (Long cuboid : remainingCuboids) {
            this.spaceCost += this.cuboidStats.getCuboidSize(cuboid).doubleValue();
        }
    }

    public BitSet getKey() {
        return this.key;
    }

    public int getLength() {
        return this.length;
    }

    public CuboidEncoder getCuboidEncoder() {
        return this.cuboidEncoder;
    }

    @Override
    public double fitness() {
        if (this.fitness == -1.0) {
            this.fitness = this.calculateFitness();
        }
        return this.fitness;
    }

    @Override
    protected boolean isSame(Chromosome another) {
        return this.equals(another);
    }

    private synchronized double calculateFitness() {
        List<Long> remainingCuboids = this.cuboidEncoder.toCuboidList(this.key);
        HashSet selectedCuboidSets = Sets.newHashSet();
        selectedCuboidSets.addAll(this.cuboidStats.getAllCuboidsForMandatory());
        CuboidBenefitModel.BenefitModel benefitModel = this.benefitPolicy.calculateBenefitTotal(remainingCuboids, selectedCuboidSets);
        double totalBenefit = benefitModel.getBenefit();
        if (this.spaceCost > this.spaceLimit) {
            totalBenefit = totalBenefit * this.spaceLimit / this.spaceCost;
        }
        return totalBenefit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitsChromosome other = (BitsChromosome)obj;
        if (this.length != other.length) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

