/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

public class CuboidBenefitModel {
    private CuboidModel cuboidModel;
    private BenefitModel benefitModel;

    public CuboidBenefitModel(CuboidModel cuboidModel, BenefitModel benefitModel) {
        this.cuboidModel = cuboidModel;
        this.benefitModel = benefitModel;
    }

    public void reset(CuboidModel cuboidModel, BenefitModel benefitModel) {
        this.cuboidModel = cuboidModel;
        this.benefitModel = benefitModel;
    }

    public Long getCuboidId() {
        return this.cuboidModel == null ? null : Long.valueOf(this.cuboidModel.getCuboidId());
    }

    public Double getBenefit() {
        return this.benefitModel == null ? null : Double.valueOf(this.benefitModel.getBenefit());
    }

    public String toString() {
        return "CuboidBenefitModel [cuboidModel=" + this.cuboidModel + ", benefitModel=" + this.benefitModel + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cuboidModel == null ? 0 : this.cuboidModel.hashCode());
        result = 31 * result + (this.benefitModel == null ? 0 : this.benefitModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CuboidBenefitModel other = (CuboidBenefitModel)obj;
        if (this.cuboidModel == null ? other.cuboidModel != null : !this.cuboidModel.equals(other.cuboidModel)) {
            return false;
        }
        return !(this.benefitModel == null ? other.benefitModel != null : !this.benefitModel.equals(other.benefitModel));
    }

    public static class BenefitModel {
        private double benefit;
        private int benefitCount;

        public BenefitModel(double benefit, int benefitCount) {
            this.benefit = benefit;
            this.benefitCount = benefitCount;
        }

        public double getBenefit() {
            return this.benefit;
        }

        public int getBenefitCount() {
            return this.benefitCount;
        }

        public String toString() {
            return "BenefitModel [benefit=" + this.benefit + ", benefitCount=" + this.benefitCount + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.benefit);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.benefitCount;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BenefitModel other = (BenefitModel)obj;
            if (Double.doubleToLongBits(this.benefit) != Double.doubleToLongBits(other.benefit)) {
                return false;
            }
            return this.benefitCount == other.benefitCount;
        }
    }

    public static class CuboidModel {
        private long cuboidId;
        private long recordCount;
        private double spaceSize;
        private double hitProbability;
        private long scanCount;

        public CuboidModel(long cuboId, long recordCount, double spaceSize, double hitProbability, long scanCount) {
            this.cuboidId = cuboId;
            this.recordCount = recordCount;
            this.spaceSize = spaceSize;
            this.hitProbability = hitProbability;
            this.scanCount = scanCount;
        }

        public long getCuboidId() {
            return this.cuboidId;
        }

        public long getRecordCount() {
            return this.recordCount;
        }

        public double getSpaceSize() {
            return this.spaceSize;
        }

        public double getHitProbability() {
            return this.hitProbability;
        }

        public long getScanCount() {
            return this.scanCount;
        }

        public String toString() {
            return "CuboidModel [cuboidId=" + this.cuboidId + ", recordCount=" + this.recordCount + ", spaceSize=" + this.spaceSize + ", hitProbability=" + this.hitProbability + ", scanCount=" + this.scanCount + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.cuboidId ^ this.cuboidId >>> 32);
            result = 31 * result + (int)(this.recordCount ^ this.recordCount >>> 32);
            long temp = Double.doubleToLongBits(this.spaceSize);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.hitProbability);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (int)(this.scanCount ^ this.scanCount >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CuboidModel other = (CuboidModel)obj;
            if (this.cuboidId != other.cuboidId) {
                return false;
            }
            if (this.recordCount != other.recordCount) {
                return false;
            }
            if (Double.doubleToLongBits(this.spaceSize) != Double.doubleToLongBits(other.spaceSize)) {
                return false;
            }
            if (this.hitProbability != other.hitProbability) {
                return false;
            }
            return this.scanCount == other.scanCount;
        }
    }
}

