/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;

public class CuboidManager {
    private final KylinConfig config;
    private final Map<String, Map<Long, Cuboid>> schedulerCuboidCache = Maps.newConcurrentMap();

    public static CuboidManager getInstance(KylinConfig config) {
        return config.getManager(CuboidManager.class);
    }

    static CuboidManager newInstance(KylinConfig config) throws IOException {
        return new CuboidManager(config);
    }

    private CuboidManager(KylinConfig config) {
        this.config = config;
    }

    public Cuboid findById(CuboidScheduler cuboidScheduler, long cuboidID) {
        Cuboid cuboid;
        ConcurrentMap cubeCache = this.schedulerCuboidCache.get(cuboidScheduler.getCuboidCacheKey());
        if (cubeCache == null) {
            cubeCache = Maps.newConcurrentMap();
            this.schedulerCuboidCache.put(cuboidScheduler.getCuboidCacheKey(), cubeCache);
        }
        if ((cuboid = (Cuboid)cubeCache.get(cuboidID)) == null) {
            long validCuboidID = cuboidScheduler.findBestMatchCuboid(cuboidID);
            cuboid = new Cuboid(cuboidScheduler.getCubeDesc(), cuboidID, validCuboidID);
            cubeCache.put(cuboidID, cuboid);
        }
        return cuboid;
    }

    public void clearCache(String cacheKey) {
        this.schedulerCuboidCache.remove(cacheKey);
    }

    public void clearCache(CubeInstance cubeInstance) {
        this.schedulerCuboidCache.remove(cubeInstance.getCuboidScheduler().getCuboidCacheKey());
    }
}

