/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtil {
    private static final Logger logger = LoggerFactory.getLogger(HadoopUtil.class);
    private static final transient ThreadLocal<Configuration> hadoopConfig = new ThreadLocal();

    public static void setCurrentConfiguration(Configuration conf) {
        hadoopConfig.set(conf);
    }

    public static Configuration getCurrentConfiguration() {
        if (hadoopConfig.get() == null) {
            Configuration conf = HadoopUtil.healSickConfig(new Configuration());
            return conf;
        }
        Configuration conf = hadoopConfig.get();
        return conf;
    }

    public static Configuration healSickConfig(Configuration conf) {
        if (StringUtils.isBlank((String)conf.get("hadoop.tmp.dir"))) {
            conf.set("hadoop.tmp.dir", "/tmp");
        }
        if (StringUtils.isBlank((String)conf.get("hbase.fs.tmp.dir"))) {
            conf.set("hbase.fs.tmp.dir", "/tmp");
        }
        conf.set("yarn.timeline-service.enabled", "false");
        return conf;
    }

    public static FileSystem getWorkingFileSystem() throws IOException {
        return HadoopUtil.getFileSystem(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
    }

    public static FileSystem getWorkingFileSystem(Configuration conf) throws IOException {
        Path workingPath = new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
        return HadoopUtil.getFileSystem(workingPath, conf);
    }

    public static FileSystem getFileSystem(String path) throws IOException {
        return HadoopUtil.getFileSystem(new Path(HadoopUtil.makeURI(path)));
    }

    public static FileSystem getFileSystem(Path path) throws IOException {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        return HadoopUtil.getFileSystem(path, conf);
    }

    public static FileSystem getFileSystem(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI makeURI(String filePath) {
        try {
            return new URI(HadoopUtil.fixWindowsPath(filePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from URI: " + filePath, e);
        }
    }

    public static String fixWindowsPath(String path) {
        if (path.startsWith("file://") && !path.startsWith("file:///") && path.contains(":\\")) {
            path = path.replace("file://", "file:///");
        }
        if (path.startsWith("file:///")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String[] parseHiveTableName(String table) {
        int cut = table.indexOf(46);
        String database = cut >= 0 ? table.substring(0, cut).trim() : "DEFAULT";
        String tableName = cut >= 0 ? table.substring(cut + 1).trim() : table.trim();
        return new String[]{database, tableName};
    }

    public static void deletePath(Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    public static byte[] toBytes(Writable writable) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            writable.write((DataOutput)out);
            out.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getFilterOnlyPath(FileSystem fs, Path baseDir, final String filter) throws IOException {
        if (!fs.exists(baseDir)) {
            return null;
        }
        FileStatus[] fileStatus = fs.listStatus(baseDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(filter);
            }
        });
        if (fileStatus.length == 1) {
            return fileStatus[0].getPath();
        }
        return null;
    }

    public static Path[] getFilteredPath(FileSystem fs, Path baseDir, final String prefix) throws IOException {
        if (!fs.exists(baseDir)) {
            return null;
        }
        FileStatus[] fileStatus = fs.listStatus(baseDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(prefix);
            }
        });
        Path[] result = new Path[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            result[i] = fileStatus[i].getPath();
        }
        return result;
    }
}

