/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.htrace;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.shaded.htrace.org.apache.htrace.HTraceConfiguration;
import org.apache.kylin.shaded.htrace.org.apache.htrace.SpanReceiver;
import org.apache.kylin.shaded.htrace.org.apache.htrace.Trace;
import org.apache.kylin.shaded.htrace.org.apache.htrace.impl.LocalFileSpanReceiver;
import org.apache.kylin.shaded.htrace.org.apache.htrace.impl.StandardOutSpanReceiver;
import org.apache.kylin.shaded.htrace.org.apache.htrace.impl.ZipkinSpanReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtraceInit {
    public static final Logger logger = LoggerFactory.getLogger(HtraceInit.class);

    public static void init() {
    }

    static {
        try {
            String fileName = System.getProperty("spanFile");
            HashSet<Object> rcvrs = new HashSet<Object>();
            if (fileName != null) {
                File f = new File(fileName);
                File parent = f.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IllegalArgumentException("Couldn't create file: " + fileName);
                }
                HashMap<String, String> conf = new HashMap<String, String>();
                conf.put("local-file-span-receiver.path", fileName);
                LocalFileSpanReceiver receiver = new LocalFileSpanReceiver(HTraceConfiguration.fromMap(conf));
                rcvrs.add(receiver);
            } else {
                rcvrs.add(new StandardOutSpanReceiver(HTraceConfiguration.EMPTY));
            }
            String hostKey = "zipkin.collector-hostname";
            String host = System.getProperty(hostKey);
            String portKey = "zipkin.collector-port";
            String port = System.getProperty(portKey);
            HashMap confMap = Maps.newHashMap();
            if (!StringUtils.isEmpty((String)host)) {
                confMap.put(hostKey, host);
                logger.info("{} is set to {}", (Object)hostKey, (Object)host);
            }
            if (!StringUtils.isEmpty((String)port)) {
                confMap.put(portKey, port);
                logger.info("{} is set to {}", (Object)portKey, (Object)port);
            }
            ZipkinSpanReceiver zipkinSpanReceiver = new ZipkinSpanReceiver(HTraceConfiguration.fromMap((Map)confMap));
            rcvrs.add(zipkinSpanReceiver);
            for (SpanReceiver spanReceiver : rcvrs) {
                Trace.addReceiver((SpanReceiver)spanReceiver);
                logger.info("SpanReceiver {} added.", (Object)spanReceiver);
            }
        }
        catch (Exception e) {
            logger.error("Failed to init HTrace", (Throwable)e);
        }
    }
}

