/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.FilterBaseTest;
import org.junit.Test;

public class FilterSerializeTest
extends FilterBaseTest {
    private void assertFilterSerDe(TupleFilter filter) {
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter(filter, newFilter);
    }

    @Test
    public void testSerialize01() {
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(this.buildGroups(), 0));
    }

    @Test
    public void testSerialize02() {
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(this.buildGroups(), 1));
    }

    @Test
    public void testSerialize03() {
        this.assertFilterSerDe(this.buildAndFilter(this.buildGroups()));
    }

    @Test
    public void testSerialize04() {
        this.assertFilterSerDe(this.buildOrFilter(this.buildGroups()));
    }

    @Test
    public void testSerialize05() {
        ColumnDesc column = new ColumnDesc();
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(groups, 0));
    }

    @Test
    public void testSerialize06() {
        ColumnDesc column = new ColumnDesc();
        column.setName("META_CATEG_NAME");
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(groups, 0));
    }

    @Test
    public void testSerialize07() {
        TableDesc table = new TableDesc();
        table.setName("TEST_KYLIN_FACT");
        table.setDatabase("DEFAULT");
        ColumnDesc column = new ColumnDesc();
        column.setTable(table);
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(groups, 0));
    }

    @Test
    public void testSerialize08() {
        TableDesc table = new TableDesc();
        table.setDatabase("DEFAULT");
        ColumnDesc column = new ColumnDesc();
        column.setTable(table);
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        this.assertFilterSerDe((TupleFilter)this.buildEQCompareFilter(groups, 0));
    }

    @Test
    public void testSerialize10() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter orFilter = this.buildOrFilter(groups);
        TupleFilter andFilter = this.buildAndFilter(groups);
        LogicalTupleFilter logicFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        logicFilter.addChild(orFilter);
        logicFilter.addChild(andFilter);
        this.assertFilterSerDe((TupleFilter)logicFilter);
    }

    @Test
    public void testSerialize11() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter orFilter = this.buildOrFilter(groups);
        TupleFilter andFilter = this.buildAndFilter(groups);
        LogicalTupleFilter logicFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
        logicFilter.addChild(orFilter);
        logicFilter.addChild(andFilter);
        this.assertFilterSerDe((TupleFilter)logicFilter);
    }

    @Test
    public void testSerialize12() {
        this.assertFilterSerDe((TupleFilter)this.buildCaseFilter(this.buildGroups()));
    }

    @Test
    public void testSerialize13() {
        this.assertFilterSerDe((TupleFilter)this.buildCompareCaseFilter(this.buildGroups(), "0"));
    }

    @Test
    public void testSerialize14() throws ParseException {
        this.assertFilterSerDe((TupleFilter)this.buildINCompareFilter(this.buildGroups().get(0)));
    }

    @Test
    public void testDynamic() {
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.EQ));
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.NEQ));
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.GT));
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.LT));
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.GTE));
        this.assertFilterSerDe((TupleFilter)this.buildCompareDynamicFilter(this.buildGroups(), TupleFilter.FilterOperatorEnum.LTE));
    }
}

