/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;
import org.apache.kylin.engine.mr.KylinReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeKeyDistributionReducer
extends KylinReducer<Text, LongWritable, Text, LongWritable> {
    public static final long ONE_GIGA_BYTES = 0x40000000L;
    private static final Logger logger = LoggerFactory.getLogger(RangeKeyDistributionReducer.class);
    private LongWritable outputValue = new LongWritable(0L);
    private int minRegionCount = 1;
    private int maxRegionCount = 500;
    private float cut = 10.0f;
    private int hfileSizeGB = 1;
    private long bytesRead = 0L;
    private List<Text> gbPoints = new ArrayList<Text>();
    private String output = null;

    protected void doSetup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        if (context.getConfiguration().get("output.path") != null) {
            this.output = context.getConfiguration().get("output.path");
        }
        if (context.getConfiguration().get("hfile.size.gb") != null) {
            this.hfileSizeGB = Float.valueOf(context.getConfiguration().get("hfile.size.gb")).intValue();
        }
        if (context.getConfiguration().get("region.split.size") != null) {
            this.cut = Float.valueOf(context.getConfiguration().get("region.split.size")).floatValue();
        }
        if (context.getConfiguration().get("region.number.min") != null) {
            this.minRegionCount = Integer.valueOf(context.getConfiguration().get("region.number.min"));
        }
        if (context.getConfiguration().get("region.number.max") != null) {
            this.maxRegionCount = Integer.valueOf(context.getConfiguration().get("region.number.max"));
        }
        logger.info("Chosen cut for htable is " + this.cut + ", max region count=" + this.maxRegionCount + ", min region count=" + this.minRegionCount + ", hfile size=" + this.hfileSizeGB);
        this.gbPoints.add(new Text());
    }

    public void doReduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        for (LongWritable v : values) {
            this.bytesRead += v.get();
        }
        if (this.bytesRead >= 0x40000000L) {
            this.gbPoints.add(new Text(key));
            this.bytesRead = 0L;
        }
    }

    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
        int nRegion = Math.round((float)this.gbPoints.size() / this.cut);
        nRegion = Math.max(this.minRegionCount, nRegion);
        nRegion = Math.min(this.maxRegionCount, nRegion);
        int gbPerRegion = this.gbPoints.size() / nRegion;
        gbPerRegion = Math.max(1, gbPerRegion);
        if (this.hfileSizeGB <= 0) {
            this.hfileSizeGB = gbPerRegion;
        }
        int hfilePerRegion = gbPerRegion / this.hfileSizeGB;
        hfilePerRegion = Math.max(1, hfilePerRegion);
        System.out.println(nRegion + " regions");
        System.out.println(gbPerRegion + " GB per region");
        System.out.println(hfilePerRegion + " hfile per region");
        Path hfilePartitionFile = new Path(this.output + "/part-r-00000_hfile");
        SequenceFile.Writer hfilePartitionWriter = new SequenceFile.Writer(hfilePartitionFile.getFileSystem(context.getConfiguration()), context.getConfiguration(), hfilePartitionFile, ImmutableBytesWritable.class, NullWritable.class);
        int hfileCountInOneRegion = 0;
        for (int i = this.hfileSizeGB; i < this.gbPoints.size(); i += this.hfileSizeGB) {
            hfilePartitionWriter.append((Writable)new ImmutableBytesWritable(this.gbPoints.get(i).getBytes()), (Writable)NullWritable.get());
            if (++hfileCountInOneRegion < hfilePerRegion) continue;
            Text key = this.gbPoints.get(i);
            this.outputValue.set((long)i);
            System.out.println(StringUtils.byteToHexString((byte[])key.getBytes()) + "\t" + this.outputValue.get());
            context.write((Object)key, (Object)this.outputValue);
            hfileCountInOneRegion = 0;
        }
        hfilePartitionWriter.close();
    }
}

