/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ModelDimensionDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="columns")
    private String[] columns;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    void init(DataModelDesc model) {
        this.table = this.table.toUpperCase();
        if (this.columns != null) {
            StringUtil.toUpperCaseArray(this.columns, this.columns);
        }
        if (model != null) {
            this.table = model.findTable(this.table).getAlias();
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    TblColRef column = model.findColumn(this.table, this.columns[i]);
                    if (column.getColumnDesc().isComputedColumn() && !model.isFactTable(column.getTableRef())) {
                        throw new RuntimeException("Computed Column on lookup table is not allowed");
                    }
                    this.columns[i] = column.getName();
                }
            }
        }
    }

    public static void capicalizeStrings(List<ModelDimensionDesc> dimensions) {
        if (dimensions != null) {
            for (ModelDimensionDesc modelDimensionDesc : dimensions) {
                modelDimensionDesc.init(null);
            }
        }
    }

    public static int getColumnCount(List<ModelDimensionDesc> modelDimensionDescs) {
        int count = 0;
        for (ModelDimensionDesc modelDimensionDesc : modelDimensionDescs) {
            if (modelDimensionDesc.getColumns() == null) continue;
            count += modelDimensionDesc.getColumns().length;
        }
        return count;
    }
}

