/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempStatementManager {
    private static final Logger logger = LoggerFactory.getLogger(TempStatementManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<TempStatementEntity> tmpStatMap;
    private CachedCrudAssist<TempStatementEntity> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static TempStatementManager getInstance(KylinConfig config) {
        return config.getManager(TempStatementManager.class);
    }

    static TempStatementManager newInstance(KylinConfig config) throws IOException {
        return new TempStatementManager(config);
    }

    private TempStatementManager(KylinConfig cfg) throws IOException {
        this.config = cfg;
        this.tmpStatMap = new CaseInsensitiveStringCache(this.config, "temp_statement");
        this.crud = new CachedCrudAssist<TempStatementEntity>(this.getStore(), "/temp_statement", TempStatementEntity.class, this.tmpStatMap){

            @Override
            protected TempStatementEntity initEntityAfterReload(TempStatementEntity t, String resourceName) {
                return t;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new TempStatementSyncListener(), "temp_statement");
    }

    public String getTempStatement(String statementId) {
        return this.getTempStatement("DEFAULT_SESSION", statementId);
    }

    public String getTempStatement(String sessionId, String statementId) {
        TempStatementEntity entity = this.getTempStatEntity(sessionId, statementId);
        return entity == null ? null : entity.statement;
    }

    public TempStatementEntity getTempStatEntity(String sessionId, String statementId) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            TempStatementEntity tempStatementEntity = (TempStatementEntity)this.tmpStatMap.get(TempStatementEntity.resourceName(sessionId, statementId));
            return tempStatementEntity;
        }
    }

    List<String> reloadAllTempStatement() throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.reloadAll();
            ArrayList<String> arrayList = new ArrayList<String>(this.tmpStatMap.keySet());
            return arrayList;
        }
    }

    public void updateTempStatement(String statementId, String statement) throws IOException {
        this.updateTempStatement("DEFAULT_SESSION", statementId, statement);
    }

    public void updateTempStatement(String sessionId, String statementId, String statement) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            TempStatementEntity entity = new TempStatementEntity(sessionId, statementId, statement);
            entity = this.prepareToOverwrite(entity, this.getTempStatEntity(sessionId, statementId));
            this.updateTempStatementWithRetry(entity, 0);
        }
    }

    private TempStatementEntity prepareToOverwrite(TempStatementEntity entity, TempStatementEntity origin) {
        if (origin == null) {
            entity.updateRandomUuid();
        } else {
            entity.setUuid(origin.getUuid());
            entity.setLastModified(origin.getLastModified());
        }
        return entity;
    }

    private void updateTempStatementWithRetry(TempStatementEntity entity, int retry) throws IOException {
        try {
            this.crud.save(entity);
        }
        catch (IllegalStateException ise) {
            logger.warn("Write conflict to update temp statement" + entity.statementId + " at try " + retry + ", will retry...");
            if (retry >= 7) {
                logger.error("Retried 7 times till got error, abandoning...", (Throwable)ise);
                throw ise;
            }
            TempStatementEntity reload = this.crud.reload(entity.resourceName());
            entity = this.prepareToOverwrite(entity, reload);
            this.updateTempStatementWithRetry(entity, ++retry);
        }
    }

    public void removeTempStatement(String statementId) throws IOException {
        this.removeTempStatement("DEFAULT_SESSION", statementId);
    }

    public void removeTempStatement(String session, String statementId) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.delete(TempStatementEntity.resourceName(session, statementId));
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class TempStatementEntity
    extends RootPersistentEntity {
        private static final String DEFAULT_SESSION_ID = "DEFAULT_SESSION";
        @JsonProperty(value="session_id")
        private String sessionId;
        @JsonProperty(value="statement_id")
        private String statementId;
        @JsonProperty(value="statement")
        private String statement;

        public TempStatementEntity() {
        }

        public TempStatementEntity(String statementId, String statement) {
            this(DEFAULT_SESSION_ID, statementId, statement);
        }

        public TempStatementEntity(String sessionId, String statementId, String statement) {
            this.sessionId = sessionId;
            this.statementId = statementId;
            this.statement = statement;
        }

        public String getStatementId() {
            return this.statementId;
        }

        public void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public String getStatement() {
            return this.statement;
        }

        public void setStatement(String statement) {
            this.statement = statement;
        }

        public String getMapKey() {
            return this.resourceName();
        }

        @Override
        public String resourceName() {
            return this.sessionId + "/" + this.statementId;
        }

        public static String resourceName(String sessionId, String statementId) {
            return sessionId + "/" + statementId;
        }

        public String concatResourcePath() {
            return TempStatementEntity.concatResourcePath(this.sessionId, this.statementId);
        }

        public static String concatResourcePath(String statementId) {
            return TempStatementEntity.concatResourcePath(DEFAULT_SESSION_ID, statementId);
        }

        public static String concatResourcePath(String sessionId, String statementId) {
            return "/temp_statement/" + sessionId + "/" + statementId + ".json";
        }
    }

    private class TempStatementSyncListener
    extends Broadcaster.Listener {
        private TempStatementSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = TempStatementManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    TempStatementManager.this.tmpStatMap.removeLocal(cacheKey);
                } else {
                    TempStatementManager.this.crud.reloadQuietly(cacheKey);
                }
            }
        }
    }
}

