/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.base.Preconditions;
import org.apache.kylin.cube.cuboid.algorithm.BPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;

public class PBPUSCalculator
extends BPUSCalculator {
    public PBPUSCalculator(CuboidStats cuboidStats) {
        super(cuboidStats);
    }

    @Override
    protected double getCostSaving(long descendant, long cuboid) {
        return this.getCuboidHitProbability(descendant) * super.getCostSaving(descendant, cuboid);
    }

    protected double getCuboidHitProbability(long cuboid) {
        return this.cuboidStats.getCuboidHitProbability(cuboid);
    }

    @Override
    public double getMinBenefitRatio() {
        Preconditions.checkArgument((this.cuboidStats.getAllCuboidsForSelection().size() > 0 ? 1 : 0) != 0, (Object)"The set of cuboids for selection is empty!!!");
        return super.getMinBenefitRatio() / (double)this.cuboidStats.getAllCuboidsForSelection().size();
    }

    @Override
    public BenefitPolicy getInstance() {
        PBPUSCalculator pbpusCalculator = new PBPUSCalculator(this.cuboidStats);
        pbpusCalculator.cuboidAggCostMap.putAll(this.cuboidAggCostMap);
        return pbpusCalculator;
    }
}

