/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPUSCalculator
implements BenefitPolicy {
    private static Logger logger = LoggerFactory.getLogger(BPUSCalculator.class);
    protected CuboidStats cuboidStats;
    protected Map<Long, Long> cuboidAggCostMap;

    public BPUSCalculator(CuboidStats cuboidStats) {
        this.cuboidStats = cuboidStats;
        this.cuboidAggCostMap = Maps.newHashMap();
    }

    @Override
    public void initBeforeStart() {
        this.cuboidAggCostMap.clear();
        for (Long cuboid : this.cuboidStats.getAllCuboidsForMandatory()) {
            if (this.getCuboidCost(cuboid) == null) continue;
            this.cuboidAggCostMap.put(cuboid, this.getCuboidCost(cuboid));
        }
        Set<Long> mandatoryCuboidSetWithStats = this.cuboidAggCostMap.keySet();
        long baseCuboidCost = this.getCuboidCost(this.cuboidStats.getBaseCuboid());
        for (Long cuboid : this.cuboidStats.getAllCuboidsForSelection()) {
            long leastCost = baseCuboidCost;
            for (Long cuboidTarget : mandatoryCuboidSetWithStats) {
                if ((cuboid | cuboidTarget) != cuboidTarget || leastCost <= this.cuboidAggCostMap.get(cuboidTarget)) continue;
                leastCost = this.cuboidAggCostMap.get(cuboidTarget);
            }
            this.cuboidAggCostMap.put(cuboid, leastCost);
        }
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefit(long cuboid, Set<Long> selected) {
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Long descendant : this.cuboidStats.getAllDescendants(cuboid)) {
            double costSaving;
            if (selected.contains(descendant) || !((costSaving = this.getCostSaving(descendant, cuboid)) > 0.0)) continue;
            totalCostSaving += costSaving;
            ++benefitCount;
        }
        double spaceCost = this.calculateSpaceCost(cuboid);
        double benefitPerUnitSpace = totalCostSaving / spaceCost;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefitTotal(List<Long> cuboidsToAdd, Set<Long> selected) {
        HashSet selectedInner = Sets.newHashSet(selected);
        HashMap cuboidAggCostMapSnapshot = Maps.newHashMap(this.cuboidAggCostMap);
        for (Long cuboid : cuboidsToAdd) {
            selectedInner.add(cuboid);
            this.propagateAggregationCost(cuboid, selectedInner);
        }
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Long cuboid : this.cuboidAggCostMap.keySet()) {
            if (this.cuboidAggCostMap.get(cuboid) >= (Long)cuboidAggCostMapSnapshot.get(cuboid)) continue;
            totalCostSaving += (double)((Long)cuboidAggCostMapSnapshot.get(cuboid) - this.cuboidAggCostMap.get(cuboid));
            ++benefitCount;
        }
        this.cuboidAggCostMap = cuboidAggCostMapSnapshot;
        double benefitPerUnitSpace = totalCostSaving;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    protected double getCostSaving(long descendant, long cuboid) {
        long cuboidCost = this.getCuboidCost(cuboid);
        long descendantAggCost = this.getCuboidAggregationCost(descendant);
        return descendantAggCost - cuboidCost;
    }

    protected Long getCuboidCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid);
    }

    private long getCuboidAggregationCost(long cuboid) {
        return this.cuboidAggCostMap.get(cuboid);
    }

    @Override
    public boolean ifEfficient(CuboidBenefitModel best) {
        if (best.getBenefit() < this.getMinBenefitRatio()) {
            logger.info(String.format("The recommended cuboid %s doesn't meet minimum benifit ratio %f", best, this.getMinBenefitRatio()));
            return false;
        }
        return true;
    }

    public double getMinBenefitRatio() {
        return 0.01;
    }

    @Override
    public void propagateAggregationCost(long cuboid, Set<Long> selected) {
        long aggregationCost = this.getCuboidCost(cuboid);
        Set<Long> childrenCuboids = this.cuboidStats.getAllDescendants(cuboid);
        for (Long child : childrenCuboids) {
            if (selected.contains(child) || aggregationCost >= this.getCuboidAggregationCost(child)) continue;
            this.cuboidAggCostMap.put(child, aggregationCost);
        }
    }

    public double calculateSpaceCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid).longValue();
    }

    @Override
    public BenefitPolicy getInstance() {
        BPUSCalculator bpusCalculator = new BPUSCalculator(this.cuboidStats);
        bpusCalculator.cuboidAggCostMap.putAll(this.cuboidAggCostMap);
        return bpusCalculator;
    }
}

