/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeCapabilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(CubeCapabilityChecker.class);

    public static CapabilityResult check(CubeInstance cube, SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        result.capable = false;
        Collection<TblColRef> dimensionColumns = CubeCapabilityChecker.getDimensionColumns(digest);
        List<FunctionDesc> aggrFunctions = digest.aggregations;
        Set<TblColRef> unmatchedDimensions = CubeCapabilityChecker.unmatchedDimensions(dimensionColumns, cube);
        Set<FunctionDesc> unmatchedAggregations = CubeCapabilityChecker.unmatchedAggregations(aggrFunctions, cube);
        CubeCapabilityChecker.tryCustomMeasureTypes(unmatchedDimensions, unmatchedAggregations, digest, cube, result);
        String rootFactTable = cube.getRootFactTable();
        if (rootFactTable.equals(digest.factTable)) {
            if (!unmatchedAggregations.isEmpty()) {
                CubeCapabilityChecker.tryDimensionAsMeasures(unmatchedAggregations, result, cube.getDescriptor().listDimensionColumnsIncludingDerived());
            }
        } else if (((CubeSegment)cube.getSegments().get(0)).getSnapshots().containsKey(digest.factTable)) {
            HashSet dimCols = Sets.newHashSet(cube.getModel().findFirstTable(digest.factTable).getColumns());
            if (!unmatchedAggregations.isEmpty()) {
                Iterator itr = unmatchedAggregations.iterator();
                while (itr.hasNext()) {
                    FunctionDesc functionDesc = (FunctionDesc)itr.next();
                    if (!dimCols.containsAll(functionDesc.getParameter().getColRefs())) continue;
                    itr.remove();
                }
            }
            CubeCapabilityChecker.tryDimensionAsMeasures(Lists.newArrayList(aggrFunctions), result, dimCols);
            if (!unmatchedDimensions.isEmpty()) {
                unmatchedDimensions.removeAll(dimCols);
            }
        } else {
            logger.info("cube {} does not touch lookup table {} at all", (Object)cube.getName(), (Object)digest.factTable);
            return result;
        }
        if (!unmatchedDimensions.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched dimensions: " + unmatchedDimensions);
            result.incapableCause = CapabilityResult.IncapableCause.unmatchedDimensions(unmatchedDimensions);
            return result;
        }
        if (!unmatchedAggregations.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched aggregations: " + unmatchedAggregations);
            result.incapableCause = CapabilityResult.IncapableCause.unmatchedAggregations(unmatchedAggregations);
            return result;
        }
        if (cube.getStorageType() == 0 && MassInTupleFilter.containsMassInTupleFilter(digest.filter)) {
            logger.info("Exclude cube " + cube.getName() + " because only v2 storage + v2 query engine supports massin");
            result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.UNSUPPORT_MASSIN);
            return result;
        }
        if (digest.limitPrecedesAggr) {
            logger.info("Exclude cube " + cube.getName() + " because there's limit preceding aggregation");
            result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.LIMIT_PRECEDE_AGGR);
            return result;
        }
        if (digest.isRawQuery && rootFactTable.equals(digest.factTable)) {
            if (cube.getConfig().isDisableCubeNoAggSQL()) {
                result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.UNSUPPORT_RAWQUERY);
                return result;
            }
            result.influences.add(new CapabilityResult.CapabilityInfluence(){

                @Override
                public double suggestCostMultiplier() {
                    return 100.0;
                }

                @Override
                public MeasureDesc getInvolvedMeasure() {
                    return null;
                }
            });
        }
        result.capable = true;
        return result;
    }

    private static Collection<TblColRef> getDimensionColumns(SQLDigest sqlDigest) {
        List<TblColRef> groupByColumns = sqlDigest.groupbyColumns;
        Set<TblColRef> filterColumns = sqlDigest.filterColumns;
        HashSet<TblColRef> dimensionColumns = new HashSet<TblColRef>();
        dimensionColumns.addAll(groupByColumns);
        dimensionColumns.addAll(filterColumns);
        return dimensionColumns;
    }

    private static Set<TblColRef> unmatchedDimensions(Collection<TblColRef> dimensionColumns, CubeInstance cube) {
        HashSet result = Sets.newHashSet(dimensionColumns);
        CubeDesc cubeDesc = cube.getDescriptor();
        result.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
        return result;
    }

    private static Set<FunctionDesc> unmatchedAggregations(Collection<FunctionDesc> aggregations, CubeInstance cube) {
        HashSet result = Sets.newHashSet(aggregations);
        CubeDesc cubeDesc = cube.getDescriptor();
        result.removeAll(cubeDesc.listAllFunctions());
        return result;
    }

    private static void tryDimensionAsMeasures(Collection<FunctionDesc> unmatchedAggregations, CapabilityResult result, Set<TblColRef> dimCols) {
        Iterator<FunctionDesc> it = unmatchedAggregations.iterator();
        while (it.hasNext()) {
            List<TblColRef> neededCols;
            FunctionDesc functionDesc = it.next();
            if (functionDesc.isCount()) {
                it.remove();
                continue;
            }
            ParameterDesc parameterDesc = functionDesc.getParameter();
            if (parameterDesc == null || (neededCols = parameterDesc.getColRefs()).size() <= 0 || !dimCols.containsAll(neededCols) || !FunctionDesc.BUILT_IN_AGGREGATIONS.contains(functionDesc.getExpression())) continue;
            result.influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
            it.remove();
        }
    }

    private static void tryCustomMeasureTypes(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, CubeInstance cube, CapabilityResult result) {
        CubeDesc cubeDesc = cube.getDescriptor();
        ArrayList influencingMeasures = Lists.newArrayList();
        for (MeasureDesc measure : cubeDesc.getMeasures()) {
            CapabilityResult.CapabilityInfluence inf;
            MeasureType<?> measureType = measure.getFunction().getMeasureType();
            if (measureType instanceof BasicMeasureType || (inf = measureType.influenceCapabilityCheck(unmatchedDimensions, unmatchedAggregations, digest, measure)) == null) continue;
            result.influences.add(inf);
            influencingMeasures.add(measure.getName() + "@" + measureType.getClass());
        }
        if (influencingMeasures.size() != 0) {
            logger.info("Cube {} CapabilityInfluences: {}", (Object)cube.getCanonicalName(), (Object)StringUtils.join((Collection)influencingMeasures, (String)","));
        }
    }
}

