/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kylin.common.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperUtil.class);

    public static String getZKConnectStringFromHBase() {
        Configuration hconf = null;
        try {
            Class<Object> hbaseConnClz = ClassUtil.forName("org.apache.kylin.storage.hbase.HBaseConnection", Object.class);
            hconf = (Configuration)hbaseConnClz.getMethod("getCurrentHBaseConfiguration", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            logger.warn("Failed to get zookeeper connect string from HBase configuration", ex);
            return null;
        }
        String serverList = hconf.get("hbase.zookeeper.quorum");
        final String port = hconf.get("hbase.zookeeper.property.clientPort");
        return StringUtils.join((Iterable)Iterables.transform(Arrays.asList(serverList.split(",")), (Function)new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return input + ":" + port;
            }
        }), (String)",");
    }
}

