/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HiveCmdBuilder {
    public static final Logger logger = LoggerFactory.getLogger(HiveCmdBuilder.class);
    public static final String HIVE_CONF_FILENAME = "kylin_hive_conf";
    static final String CREATE_HQL_TMP_FILE_TEMPLATE = "cat >%s<<EOL\n%sEOL";
    private KylinConfig kylinConfig;
    private final Map<String, String> hiveConfProps = new HashMap<String, String>();
    private final ArrayList<String> statements = Lists.newArrayList();

    public HiveCmdBuilder() {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.loadHiveConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build() {
        HiveClientMode clientMode = HiveClientMode.valueOf(this.kylinConfig.getHiveClientMode().toUpperCase());
        String beelineShell = this.kylinConfig.getHiveBeelineShell();
        String beelineParams = this.kylinConfig.getHiveBeelineParams();
        if (this.kylinConfig.getEnableSparkSqlForTableOps()) {
            clientMode = HiveClientMode.BEELINE;
            beelineShell = this.kylinConfig.getSparkSqlBeelineShell();
            beelineParams = this.kylinConfig.getSparkSqlBeelineParams();
            if (StringUtils.isBlank((String)beelineShell)) {
                throw new IllegalStateException("Missing config 'kylin.source.hive.sparksql-beeline-shell', please check kylin.properties");
            }
        }
        StringBuffer buf = new StringBuffer();
        switch (clientMode) {
            case CLI: {
                buf.append("hive -e \"");
                for (String statement : this.statements) {
                    buf.append(statement).append("\n");
                }
                buf.append("\"");
                buf.append(this.parseProps());
                break;
            }
            case BEELINE: {
                String tmpHqlPath = null;
                StringBuilder hql = new StringBuilder();
                try {
                    tmpHqlPath = "/tmp/" + System.currentTimeMillis() + ".hql";
                    for (String statement : this.statements) {
                        hql.append(statement);
                        hql.append("\n");
                    }
                    String createFileCmd = String.format(CREATE_HQL_TMP_FILE_TEMPLATE, tmpHqlPath, hql);
                    buf.append(createFileCmd);
                    buf.append("\n");
                    buf.append(beelineShell);
                    buf.append(" ");
                    buf.append(beelineParams);
                    buf.append(this.parseProps());
                    buf.append(" -f ");
                    buf.append(tmpHqlPath);
                    buf.append(";ret_code=$?;rm -f ");
                    buf.append(tmpHqlPath);
                    buf.append(";exit $ret_code");
                    break;
                }
                finally {
                    if (tmpHqlPath != null && logger.isDebugEnabled()) {
                        logger.debug("The SQL to execute in beeline: \n" + hql);
                    }
                }
            }
            default: {
                throw new RuntimeException("Hive client cannot be recognized: " + (Object)((Object)clientMode));
            }
        }
        return buf.toString();
    }

    private String parseProps() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, String> prop : this.hiveConfProps.entrySet()) {
            s.append(" --hiveconf ");
            s.append(prop.getKey());
            s.append("=");
            s.append(prop.getValue());
        }
        return s.toString();
    }

    public void reset() {
        this.statements.clear();
        this.hiveConfProps.clear();
    }

    public void setHiveConfProps(Map<String, String> hiveConfProps) {
        this.hiveConfProps.clear();
        this.hiveConfProps.putAll(hiveConfProps);
    }

    public void overwriteHiveProps(Map<String, String> overwrites) {
        this.hiveConfProps.putAll(overwrites);
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public void addStatementWithRedistributeBy(String statement) {
        StringBuilder builder = new StringBuilder();
        builder.append(statement);
        this.addStatementWithRedistributeBy(builder);
    }

    public void addStatementWithRedistributeBy(StringBuilder statement) {
        statement.append("DISTRIBUTE BY RAND()").append(";\n");
        this.statements.add(statement.toString());
    }

    public void addStatements(String[] stats) {
        for (String s : stats) {
            this.statements.add(s);
        }
    }

    public String toString() {
        return this.build();
    }

    private void loadHiveConfiguration() {
        File hiveConfFile;
        String hiveConfFileName = "kylin_hive_conf.xml";
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            hiveConfFile = new File(path, hiveConfFileName);
        } else {
            path = KylinConfig.getKylinHome();
            if (StringUtils.isEmpty((String)path)) {
                logger.error("KYLIN_HOME is not set, can not locate hive conf: {}.xml", (Object)HIVE_CONF_FILENAME);
                return;
            }
            hiveConfFile = new File(path + File.separator + "conf", hiveConfFileName);
        }
        if (!hiveConfFile.exists()) {
            throw new RuntimeException("Missing config file: " + hiveConfFile.getAbsolutePath());
        }
        String fileUrl = OptionsHelper.convertToFileURL(hiveConfFile.getAbsolutePath());
        try {
            File file = new File(fileUrl);
            if (file.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(file);
                NodeList nl = doc.getElementsByTagName("property");
                this.hiveConfProps.clear();
                for (int i = 0; i < nl.getLength(); ++i) {
                    String key = doc.getElementsByTagName("name").item(i).getFirstChild().getNodeValue();
                    String value = doc.getElementsByTagName("value").item(i).getFirstChild().getNodeValue();
                    if (key.equals("tmpjars")) continue;
                    this.hiveConfProps.put(key, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse hive conf file ", e);
        }
    }

    public static enum HiveClientMode {
        CLI,
        BEELINE;

    }
}

