/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.kylin.common.util.StringUtil;

public class ClasspathScanner {
    private File[] rootResources;

    public static void main(final String[] args) {
        ClasspathScanner scanner = new ClasspathScanner();
        if (args.length == 0) {
            for (File f : scanner.rootResources) {
                System.out.println(f.getAbsolutePath());
            }
            System.exit(0);
        }
        final int[] hitCount = new int[1];
        scanner.scan("", new ResourceVisitor(){

            @Override
            public void accept(File dir, String relativeFileName) {
                this.check(dir.getAbsolutePath(), relativeFileName.replace('\\', '/'));
            }

            @Override
            public void accept(ZipFile archive, ZipEntry zipEntry) {
                this.check(archive.getName(), zipEntry.getName().replace('\\', '/'));
            }

            private void check(String base, String relativePath) {
                boolean hit = false;
                for (int i = 0; i < args.length && !hit; ++i) {
                    hit = relativePath.contains(args[i]) || ClasspathScanner.match(args[i], relativePath);
                }
                if (hit) {
                    System.out.println(base + " - " + relativePath);
                    hitCount[0] = hitCount[0] + 1;
                }
            }
        });
        int exitCode = hitCount[0] > 0 ? 0 : 1;
        System.exit(exitCode);
    }

    public static String[] findResources(String suffix) {
        ClasspathScanner scanner = new ClasspathScanner();
        final ArrayList result = new ArrayList();
        scanner.scan(suffix, new ResourceVisitor(){

            @Override
            public void accept(File dir, String relativeFileName) {
                result.add(relativeFileName.replace('\\', '/'));
            }

            @Override
            public void accept(ZipFile archive, ZipEntry zipEntry) {
                result.add(zipEntry.getName().replace('\\', '/'));
            }
        });
        return result.toArray(new String[result.size()]);
    }

    public ClasspathScanner() {
        this(Thread.currentThread().getContextClassLoader(), true);
    }

    public ClasspathScanner(ClassLoader classLoader, boolean recursive) {
        this.rootResources = ClasspathScanner.extractRoots(classLoader, recursive);
    }

    static File[] extractRoots(ClassLoader loader, boolean recursive) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        while (loader != null) {
            loaders.add(loader);
            if (!recursive) break;
            loader = loader.getParent();
        }
        ArrayList<File> roots = new ArrayList<File>();
        for (int i = loaders.size() - 1; i >= 0; --i) {
            ClassLoader l = (ClassLoader)loaders.get(i);
            if (!(l instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)l).getURLs()) {
                File f = new File(url.getFile().replace("%20", " "));
                roots.add(f);
            }
        }
        return roots.toArray(new File[roots.size()]);
    }

    public ClasspathScanner(File[] rootResources) {
        this.rootResources = rootResources;
    }

    public void scan(String suffix, ResourceVisitor visitor) {
        for (int i = 0; i < this.rootResources.length; ++i) {
            if (!this.rootResources[i].exists()) continue;
            if (this.rootResources[i].isDirectory()) {
                this.scanDirectory(this.rootResources[i], suffix, visitor);
                continue;
            }
            if (!this.rootResources[i].getName().contains(".zip") && !this.rootResources[i].getName().contains(".jar")) continue;
            this.scanArchive(this.rootResources[i], suffix, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanArchive(File archive, String suffix, ResourceVisitor visitor) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(archive, 1);
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                if (!entry.getName().endsWith(suffix)) continue;
                visitor.accept(zip, entry);
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void scanDirectory(File dir, String suffix, ResourceVisitor visitor) {
        String[] files = ClasspathScanner.scanFiles(dir, "*" + suffix);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(suffix)) continue;
            visitor.accept(dir, files[i]);
        }
    }

    public static String[] scanFiles(File dir, String ... includes) {
        return ClasspathScanner.scanFiles(dir, includes, null);
    }

    public static String[] scanFiles(File dir, String[] includes, String[] excludes) {
        int i;
        if (includes != null) {
            for (i = 0; i < includes.length; ++i) {
                includes[i] = StringUtil.trimSuffix(includes[i], "/");
            }
        }
        if (excludes != null) {
            for (i = 0; i < excludes.length; ++i) {
                excludes[i] = StringUtil.trimSuffix(excludes[i], "/");
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> queue = new ArrayList<String>();
        queue.add("");
        while (!queue.isEmpty()) {
            String dirPath = (String)queue.remove(queue.size() - 1);
            File dirFile = dirPath.length() == 0 ? dir : new File(dir, dirPath);
            File[] files = dirFile.listFiles();
            for (int i2 = 0; files != null && i2 < files.length; ++i2) {
                File f = files[i2];
                String path = dirPath + (dirPath.length() == 0 ? "" : "/") + f.getName();
                if (f.isDirectory()) {
                    if (!ClasspathScanner.scanFiles_isIncluded(path, null, excludes)) continue;
                    queue.add(path);
                    continue;
                }
                if (!f.isFile() || !ClasspathScanner.scanFiles_isIncluded(path, includes, excludes)) continue;
                result.add(path);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean scanFiles_isIncluded(String path, String[] includes, String[] excludes) {
        if (includes != null && includes.length != 0) {
            boolean included = false;
            for (int i = 0; !included && i < includes.length; ++i) {
                if (!ClasspathScanner.match(includes[i], path) && !ClasspathScanner.match(includes[i] + "/*", path)) continue;
                included = true;
            }
            if (!included) {
                return false;
            }
        }
        if (excludes != null && excludes.length != 0) {
            for (int i = 0; i < excludes.length; ++i) {
                if (!ClasspathScanner.match(excludes[i], path)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        int i = 0;
        int j = 0;
        int ii = 0;
        int jj = 0;
        int plen = pattern.length();
        int slen = str.length();
        while (i < plen) {
            int wordEnd;
            int wordStart;
            for (wordStart = i; wordStart < plen && pattern.charAt(wordStart) == '*'; ++wordStart) {
            }
            if (wordStart == plen) {
                return true;
            }
            for (wordEnd = wordStart + 1; wordEnd < plen && pattern.charAt(wordEnd) != '*'; ++wordEnd) {
            }
            int lastPossible = slen - (wordEnd - wordStart) + 1;
            while (j < lastPossible) {
                ii = wordStart;
                jj = j;
                while (ii < wordEnd && (pattern.charAt(ii) == '?' || pattern.charAt(ii) == str.charAt(jj))) {
                    ++ii;
                    ++jj;
                }
                if (ii == wordEnd) break;
                if (wordStart == i) {
                    return false;
                }
                ++j;
            }
            if (j >= lastPossible) {
                return false;
            }
            i = ii;
            j = jj;
        }
        return j == slen;
    }

    public static interface ResourceVisitor {
        public void accept(File var1, String var2);

        public void accept(ZipFile var1, ZipEntry var2);
    }
}

