/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    protected static Pattern fullRestPattern = Pattern.compile("(?:([^:]+)[:]([^@]+)[@])?([^:]+)(?:[:](\\d+))?");
    private int httpConnectionTimeoutMs = 30000;
    private int httpSocketTimeoutMs = 120000;
    public static final String SCHEME_HTTP = "http://";
    public static final String KYLIN_API_PATH = "/kylin/api";
    protected String host;
    protected int port;
    protected String baseUrl;
    protected String userName;
    protected String password;
    protected DefaultHttpClient client;

    public static boolean matchFullRestPattern(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        return m.matches();
    }

    public RestClient(String uri) {
        this(uri, null, null);
    }

    public RestClient(String uri, Integer httpConnectionTimeoutMs, Integer httpSocketTimeoutMs) {
        Matcher m = fullRestPattern.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("URI: " + uri + " -- does not match pattern " + fullRestPattern);
        }
        String user = m.group(1);
        String pwd = m.group(2);
        String host = m.group(3);
        String portStr = m.group(4);
        int port = Integer.parseInt(portStr == null ? "7070" : portStr);
        if (httpConnectionTimeoutMs != null) {
            this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        }
        if (httpSocketTimeoutMs != null) {
            this.httpSocketTimeoutMs = httpSocketTimeoutMs;
        }
        this.init(host, port, user, pwd);
    }

    public RestClient(String host, int port, String userName, String password) {
        this(host, port, userName, password, null, null);
    }

    public RestClient(String host, int port, String userName, String password, Integer httpConnectionTimeoutMs, Integer httpSocketTimeoutMs) {
        if (httpConnectionTimeoutMs != null) {
            this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        }
        if (httpSocketTimeoutMs != null) {
            this.httpSocketTimeoutMs = httpSocketTimeoutMs;
        }
        this.init(host, port, userName, password);
    }

    private void init(String host, int port, String userName, String password) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.baseUrl = SCHEME_HTTP + host + ":" + port + KYLIN_API_PATH;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.httpSocketTimeoutMs);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.httpConnectionTimeoutMs);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        cm.setDefaultMaxPerRoute(config.getRestClientDefaultMaxPerRoute());
        cm.setMaxTotal(config.getRestClientMaxTotal());
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        if (userName != null && password != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.client.setCredentialsProvider((CredentialsProvider)provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wipeCache(String entity, String event, String cacheKey) throws IOException {
        String url = this.baseUrl + "/cache/" + entity + "/" + cacheKey + "/" + event;
        HttpPut request = new HttpPut(url);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
        }
        finally {
            this.cleanup((HttpRequestBase)request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKylinProperties() throws IOException {
        String url = this.baseUrl + "/admin/config";
        HttpGet request = new HttpGet(url);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            Map<String, String> map = JsonUtil.readValueAsMap(msg);
            msg = map.get("config");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
            String string = msg;
            return string;
        }
        finally {
            this.cleanup((HttpRequestBase)request, response);
        }
    }

    public boolean enableCache() throws IOException {
        return this.setCache(true);
    }

    public boolean disableCache() throws IOException {
        return this.setCache(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildCube(String cubeName, long startTime, long endTime, String buildType) throws Exception {
        String url = this.baseUrl + "/cubes/" + cubeName + "/build";
        HttpPut put = this.newPut(url);
        HttpResponse response = null;
        try {
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("startTime", startTime + "");
            paraMap.put("endTime", endTime + "");
            paraMap.put("buildType", buildType);
            String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
            put.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
            response = this.client.execute((HttpUriRequest)put);
            this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with build cube url " + url + "\n" + jsonMsg);
            }
            boolean bl = true;
            this.cleanup((HttpRequestBase)put, response);
            return bl;
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)put, response);
            throw throwable;
        }
    }

    public boolean disableCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/disable");
    }

    public boolean enableCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/enable");
    }

    public boolean purgeCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/purge");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCube(String cubeName) throws Exception {
        String url = this.baseUrl + "/cubes/" + cubeName;
        HttpGet get = this.newGet(url);
        HttpResponse response = null;
        try {
            get.setURI(new URI(url));
            response = this.client.execute((HttpUriRequest)get);
            HashMap hashMap = this.dealResponse(response);
            this.cleanup((HttpRequestBase)get, response);
            return hashMap;
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)get, response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeCubeStatus(String url) throws Exception {
        HttpPut put = this.newPut(url);
        HttpResponse response = null;
        try {
            HashMap paraMap = new HashMap();
            String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
            put.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
            response = this.client.execute((HttpUriRequest)put);
            this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n" + jsonMsg);
            }
            boolean bl = true;
            this.cleanup((HttpRequestBase)put, response);
            return bl;
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)put, response);
            throw throwable;
        }
    }

    public HttpResponse query(String sql, String project) throws IOException {
        String url = this.baseUrl + "/query";
        HttpPost post = this.newPost(url);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("sql", sql);
        paraMap.put("project", project);
        String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        return response;
    }

    public void clearCacheForCubeMigration(String cube, String project, String model, Map<String, String> tableToProjects) throws IOException {
        String url = this.baseUrl + "/cache/migration";
        HttpPost post = new HttpPost(url);
        post.addHeader("Accept", "application/json, text/plain, */*");
        post.addHeader("Content-Type", "application/json");
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("cube", cube);
        paraMap.put("project", project);
        paraMap.put("model", model);
        paraMap.put("tableToProjects", tableToProjects);
        String jsonMsg = JsonUtil.writeValueAsString(paraMap);
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode());
        }
    }

    private HashMap dealResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode());
        }
        String result = this.getContent(response);
        HashMap resultMap = (HashMap)new ObjectMapper().readValue(result, HashMap.class);
        return resultMap;
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])(this.userName + ":" + this.password).getBytes());
        method.addHeader("Authorization", "Basic " + basicAuth);
    }

    private HttpPost newPost(String url) {
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders((HttpRequestBase)post);
        return post;
    }

    private HttpPut newPut(String url) {
        HttpPut put = new HttpPut(url);
        this.addHttpHeaders((HttpRequestBase)put);
        return put;
    }

    private HttpGet newGet(String url) {
        HttpGet get = new HttpGet();
        this.addHttpHeaders((HttpRequestBase)get);
        return get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCache(boolean flag) throws IOException {
        HttpResponse response;
        HttpPut put;
        block3: {
            String url = this.baseUrl + "/admin/config";
            put = this.newPut(url);
            response = null;
            try {
                HashMap<String, String> paraMap = new HashMap<String, String>();
                paraMap.put("key", "kylin.query.cache-enabled");
                paraMap.put("value", flag + "");
                put.setEntity((HttpEntity)new StringEntity(new ObjectMapper().writeValueAsString(paraMap), "UTF-8"));
                response = this.client.execute((HttpUriRequest)put);
                EntityUtils.consume((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) break block3;
                boolean bl = false;
                this.cleanup((HttpRequestBase)put, response);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanup((HttpRequestBase)put, response);
                throw throwable;
            }
        }
        boolean bl = true;
        this.cleanup((HttpRequestBase)put, response);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(HttpResponse response) throws IOException {
        InputStreamReader reader = null;
        BufferedReader rd = null;
        StringBuffer result = new StringBuffer();
        try {
            reader = new InputStreamReader(response.getEntity().getContent());
            rd = new BufferedReader(reader);
            String line = null;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(rd);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)rd);
        return result.toString();
    }

    private void cleanup(HttpRequestBase request, HttpResponse response) {
        try {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (Exception ex) {
            logger.error("Error during HTTP connection cleanup", (Throwable)ex);
        }
        request.releaseConnection();
    }
}

