/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceStore
extends ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceStore.class);
    File root;

    public FileResourceStore(KylinConfig kylinConfig) {
        super(kylinConfig);
        this.root = new File(this.getPath(kylinConfig)).getAbsoluteFile();
        if (!this.root.exists()) {
            throw new IllegalArgumentException("File not exist by '" + kylinConfig.getMetadataUrl() + "': " + this.root.getAbsolutePath());
        }
    }

    protected String getPath(KylinConfig kylinConfig) {
        return kylinConfig.getMetadataUrl().getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            String[] names = this.file(folderPath).list();
            if (names == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            TreeSet<String> r = new TreeSet<String>();
            String prefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
            for (String n : names) {
                r.add(prefix + n);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return f.exists() && f.isFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<RawResource> getAllResourcesImpl(String folderPath, long timeStart, long timeEndExclusive) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            NavigableSet<String> resources = this.listResources(folderPath);
            if (resources == null) {
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)resources.size());
            try {
                for (String res : resources) {
                    RawResource resource;
                    long ts = this.getResourceTimestampImpl(res);
                    if (timeStart > ts || ts >= timeEndExclusive || (resource = this.getResourceImpl(res)) == null) continue;
                    result.add(resource);
                }
            }
            catch (IOException ex) {
                for (RawResource rawResource : result) {
                    IOUtils.closeQuietly((InputStream)rawResource.inputStream);
                }
                throw ex;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            if (f.exists() && f.isFile()) {
                if (f.length() == 0L) {
                    logger.warn("Zero length file: " + f.getAbsolutePath());
                }
                FileInputStream resource = new FileInputStream(f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                IOUtils.copy((InputStream)resource, (OutputStream)baos);
                IOUtils.closeQuietly((InputStream)resource);
                byte[] data = baos.toByteArray();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new RawResource(new ByteArrayInputStream(data), f.lastModified());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            if (f.exists() && f.isFile()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return f.lastModified();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putResourceImpl(String resPath, InputStream content, long ts) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            f.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(f);
            try {
                IOUtils.copy((InputStream)content, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            f.setLastModified(ts);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, IllegalStateException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            if (f.exists() && f.lastModified() != oldTS || !f.exists() && oldTS != 0L) {
                throw new IllegalStateException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but found " + f.lastModified());
            }
            this.putResourceImpl(resPath, new ByteArrayInputStream(content), newTS);
            // ** MonitorExit[var7_5] (shouldn't be in output)
            return f.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            File f = this.file(resPath);
            f.delete();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        Class<FileResourceStore> clazz = FileResourceStore.class;
        synchronized (FileResourceStore.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.file(resPath).toString();
        }
    }

    private File file(String resPath) {
        if (resPath.equals("/")) {
            return this.root;
        }
        return new File(this.root, resPath);
    }

    public String toString() {
        return this.root.getAbsolutePath();
    }
}

