/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.storage.hbase.steps.RangeKeyDistributionJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeKeyDistributionJobTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = HadoopUtil.getCurrentConfiguration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapreduce.framework.name", "local");
        this.conf.set("mapreduce.application.framework.path", "");
        this.conf.set("mapreduce.task.io.sort.mb", "10");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testJob() throws Exception {
        String input = "src/test/resources/data/base_cuboid/,src/test/resources/data/8d_cuboid/";
        String output = "target/test-output/key_distribution_range/";
        String jobname = "calculate_splits";
        String cubename = "test_kylin_cube_with_slr_ready";
        FileUtil.fullyDelete((File)new File(output));
        String[] args = new String[]{"-input", input, "-output", output, "-jobname", jobname, "-cubename", cubename};
        Assert.assertEquals((String)"Job failed", (long)0L, (long)ToolRunner.run((Configuration)this.conf, (Tool)new RangeKeyDistributionJob(), (String[])args));
    }
}

