/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.storage.hbase.steps.CubeHFileMapper;
import org.apache.kylin.storage.hbase.steps.MockupMapContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CubeHFileMapper2Test
extends LocalFileMetadataTestCase {
    String cubeName = "test_kylin_cube_with_slr_ready";
    MeasureCodec codec;
    Object[] outKV = new Object[2];

    @Before
    public void setup() throws Exception {
        this.createTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
        FileUtils.copyDirectory((File)new File(CubeHFileMapper2Test.getTestConfig().getMetadataUrl().toString()), (File)new File("../job/meta"));
        CubeDesc desc = CubeManager.getInstance((KylinConfig)CubeHFileMapper2Test.getTestConfig()).getCube(this.cubeName).getDescriptor();
        this.codec = new MeasureCodec((Collection)desc.getMeasures());
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
    }

    @Test
    public void testBasic() throws Exception {
        Configuration hconf = HadoopUtil.getCurrentConfiguration();
        Mapper.Context context = MockupMapContext.create(hconf, this.cubeName, this.outKV);
        CubeHFileMapper mapper = new CubeHFileMapper();
        mapper.doSetup(context);
        Text key = new Text("not important");
        Text value = new Text(new byte[]{2, 2, 51, -79, 1});
        mapper.map((Object)key, (Object)value, context);
        ImmutableBytesWritable outKey = (ImmutableBytesWritable)this.outKV[0];
        KeyValue outValue = (KeyValue)this.outKV[1];
        Assert.assertTrue((Bytes.compareTo((byte[])key.getBytes(), (int)0, (int)key.getLength(), (byte[])outKey.get(), (int)outKey.getOffset(), (int)outKey.getLength()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])value.getBytes(), (int)0, (int)value.getLength(), (byte[])outValue.getValueArray(), (int)outValue.getValueOffset(), (int)outValue.getValueLength()) == 0 ? 1 : 0) != 0);
    }
}

