/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hdfs;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.storage.hbase.util.ZookeeperUtil;
import org.apache.kylin.storage.hdfs.ResourceLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static Logger logger = LoggerFactory.getLogger(LockManager.class);
    private final KylinConfig config;
    final CuratorFramework zkClient;
    private String lockRootPath;

    public LockManager(String lockRootPath) throws Exception {
        this(KylinConfig.getInstanceFromEnv(), lockRootPath);
    }

    public LockManager(KylinConfig config, String lockRootPath) throws Exception {
        this.config = config;
        this.lockRootPath = lockRootPath;
        String zkConnectString = ZookeeperUtil.getZKConnectString();
        logger.info("zk connection string:" + zkConnectString);
        if (StringUtils.isEmpty((CharSequence)zkConnectString)) {
            throw new IllegalArgumentException("ZOOKEEPER_QUORUM is empty!");
        }
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        this.zkClient = CuratorFrameworkFactory.newClient((String)zkConnectString, (RetryPolicy)retryPolicy);
        this.zkClient.start();
        if (this.zkClient.checkExists().forPath(lockRootPath) == null) {
            this.zkClient.create().creatingParentsIfNeeded().forPath(lockRootPath);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LockManager.this.close();
            }
        }));
    }

    public ResourceLock getLock(String name) throws Exception {
        String lockPath = this.getLockPath(name);
        InterProcessMutex lock = new InterProcessMutex(this.zkClient, lockPath);
        return new ResourceLock(lockPath, lock);
    }

    public void releaseLock(ResourceLock lock) throws IOException {
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (Exception e) {
            throw new IOException("Fail to release lock", e);
        }
    }

    public String getLockPath(String resourceName) {
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        if (resourceName.endsWith("/")) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return this.lockRootPath + resourceName;
    }

    public void close() {
        try {
            this.zkClient.close();
        }
        catch (Exception e) {
            logger.error("error occurred to close PathChildrenCache", (Throwable)e);
        }
    }
}

