/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.RangeKeyDistributionMapper;
import org.apache.kylin.storage.hbase.steps.RangeKeyDistributionReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeKeyDistributionJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(RangeKeyDistributionJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            this.parseOptions(options, args);
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            KylinConfig kylinConfig = cube.getConfig();
            this.setJobClasspath(this.job, kylinConfig);
            RangeKeyDistributionJob.addInputDirs((String)this.getOptionValue(OPTION_INPUT_PATH), (Job)this.job);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(RangeKeyDistributionMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(LongWritable.class);
            this.job.setReducerClass(RangeKeyDistributionReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(LongWritable.class);
            this.job.setNumReduceTasks(1);
            this.deletePath(this.job.getConfiguration(), output);
            float hfileSizeGB = kylinConfig.getHBaseHFileSizeGB();
            float regionSplitSize = kylinConfig.getKylinHBaseRegionCut();
            int compactionThreshold = Integer.valueOf(HBaseConnection.getCurrentHBaseConfiguration().get("hbase.hstore.compactionThreshold", "3"));
            if (hfileSizeGB > 0.0f && hfileSizeGB * (float)compactionThreshold < regionSplitSize) {
                hfileSizeGB = regionSplitSize / (float)compactionThreshold;
                logger.info("Adjust hfile size' to " + hfileSizeGB);
            }
            int maxRegionCount = kylinConfig.getHBaseRegionCountMax();
            int minRegionCount = kylinConfig.getHBaseRegionCountMin();
            this.job.getConfiguration().set("output.path", output.toString());
            this.job.getConfiguration().set("hfile.size.gb", String.valueOf(hfileSizeGB));
            this.job.getConfiguration().set("region.split.size", String.valueOf(regionSplitSize));
            this.job.getConfiguration().set("region.number.max", String.valueOf(maxRegionCount));
            this.job.getConfiguration().set("region.number.min", String.valueOf(minRegionCount));
            TableMapReduceUtil.addDependencyJars((Configuration)this.job.getConfiguration(), (Class[])new Class[]{ImmutableBytesWritable.class, NullWritable.class});
            return this.waitForCompletion(this.job);
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new RangeKeyDistributionJob(), (String[])args);
        System.exit(exitCode);
    }
}

