/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeGCStep
extends AbstractExecutable {
    private static final String OLD_HTABLES = "oldHTables";
    private static final Logger logger = LoggerFactory.getLogger(MergeGCStep.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        try {
            logger.info("Sleep one minute before deleting the Htables");
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted");
        }
        logger.info("Start doing merge gc work");
        StringBuffer output = new StringBuffer();
        List<String> oldTables = this.getOldHTables();
        if (oldTables != null && oldTables.size() > 0) {
            String metadataUrlPrefix = KylinConfig.getInstanceFromEnv().getMetadataUrlPrefix();
            Admin admin = null;
            try {
                Connection conn = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl());
                admin = conn.getAdmin();
                for (String table : oldTables) {
                    if (!admin.tableExists(TableName.valueOf((String)table))) continue;
                    HTableDescriptor tableDescriptor = admin.getTableDescriptor(TableName.valueOf((String)table));
                    String host = tableDescriptor.getValue("KYLIN_HOST");
                    if (metadataUrlPrefix.equalsIgnoreCase(host)) {
                        if (admin.isTableEnabled(TableName.valueOf((String)table))) {
                            admin.disableTable(TableName.valueOf((String)table));
                        }
                        admin.deleteTable(TableName.valueOf((String)table));
                        logger.debug("Dropped htable: " + table);
                        output.append("HBase table " + table + " is dropped. \n");
                        continue;
                    }
                    logger.debug("Skip htable: " + table);
                    output.append("Skip htable: " + table + ". \n");
                }
            }
            catch (IOException e) {
                output.append("Got error when drop HBase table, exiting... \n");
                ExecuteResult executeResult = new ExecuteResult(ExecuteResult.State.ERROR, output.append(e.getLocalizedMessage()).toString());
                return executeResult;
            }
            finally {
                if (admin != null) {
                    try {
                        admin.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getLocalizedMessage());
                    }
                }
            }
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, output.toString());
    }

    public void setOldHTables(List<String> ids) {
        this.setParam(OLD_HTABLES, StringUtils.join(ids, (String)","));
    }

    private List<String> getOldHTables() {
        String ids = this.getParam(OLD_HTABLES);
        if (ids != null) {
            String[] splitted = StringUtils.split((String)ids, (String)",");
            ArrayList result = Lists.newArrayListWithExpectedSize((int)splitted.length);
            for (String id : splitted) {
                result.add(id);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

