/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.storage.hbase.steps.KeyValueCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseCuboidWriter
implements ICuboidWriter {
    private static final Logger logger = LoggerFactory.getLogger(HBaseCuboidWriter.class);
    private static final int BATCH_PUT_THRESHOLD = 10000;
    private final List<KeyValueCreator> keyValueCreators;
    private final int nColumns;
    private final Table hTable;
    private final CubeDesc cubeDesc;
    private final CubeSegment cubeSegment;
    private final Object[] measureValues;
    private List<Put> puts = Lists.newArrayList();
    private AbstractRowKeyEncoder rowKeyEncoder;
    private byte[] keybuf;

    public HBaseCuboidWriter(CubeSegment segment, Table hTable) {
        this.keyValueCreators = Lists.newArrayList();
        this.cubeSegment = segment;
        this.cubeDesc = this.cubeSegment.getCubeDesc();
        for (HBaseColumnFamilyDesc cfDesc : this.cubeDesc.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc colDesc : cfDesc.getColumns()) {
                this.keyValueCreators.add(new KeyValueCreator(this.cubeDesc, colDesc));
            }
        }
        this.nColumns = this.keyValueCreators.size();
        this.hTable = hTable;
        this.measureValues = new Object[this.cubeDesc.getMeasures().size()];
    }

    private byte[] copy(byte[] array, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(array, offset, result, 0, length);
        return result;
    }

    private byte[] createKey(Long cuboidId, GTRecord record) {
        if (this.rowKeyEncoder == null || this.rowKeyEncoder.getCuboidID() != cuboidId.longValue()) {
            this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance(this.cubeSegment, Cuboid.findById(this.cubeSegment, (long)cuboidId));
            this.keybuf = this.rowKeyEncoder.createBuf();
        }
        this.rowKeyEncoder.encode(record, record.getInfo().getPrimaryKey(), this.keybuf);
        return this.keybuf;
    }

    @Override
    public void write(long cuboidId, GTRecord record) throws IOException {
        byte[] key = this.createKey(cuboidId, record);
        Cuboid cuboid = Cuboid.findById(this.cubeSegment, cuboidId);
        int nDims = cuboid.getColumns().size();
        ImmutableBitSet bitSet = new ImmutableBitSet(nDims, nDims + this.cubeDesc.getMeasures().size());
        for (int i = 0; i < this.nColumns; ++i) {
            Object[] values = record.getValues(bitSet, this.measureValues);
            KeyValue keyValue = this.keyValueCreators.get(i).create(key, 0, key.length, values);
            Put put = new Put(this.copy(key, 0, key.length));
            byte[] family = this.copy(keyValue.getFamilyArray(), keyValue.getFamilyOffset(), keyValue.getFamilyLength());
            byte[] qualifier = this.copy(keyValue.getQualifierArray(), keyValue.getQualifierOffset(), keyValue.getQualifierLength());
            byte[] value = this.copy(keyValue.getValueArray(), keyValue.getValueOffset(), keyValue.getValueLength());
            put.add(family, qualifier, value);
            this.puts.add(put);
        }
        if (this.puts.size() >= 10000) {
            this.flush();
        }
    }

    @Override
    public final void flush() throws IOException {
        if (!this.puts.isEmpty()) {
            long t = System.currentTimeMillis();
            if (this.hTable != null) {
                this.hTable.put(this.puts);
            }
            logger.info("commit total " + this.puts.size() + " puts, totally cost:" + (System.currentTimeMillis() - t) + "ms");
            this.puts.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        IOUtils.closeQuietly((Closeable)this.hTable);
    }
}

