/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class SQLDigest {
    public String factTable;
    public Set<TblColRef> allColumns;
    public List<JoinDesc> joinDescs;
    public List<TblColRef> groupbyColumns;
    public Set<TblColRef> subqueryJoinParticipants;
    public Set<TblColRef> metricColumns;
    public List<FunctionDesc> aggregations;
    public List<SQLCall> aggrSqlCalls;
    public Set<TblColRef> filterColumns;
    public TupleFilter filter;
    public TupleFilter havingFilter;
    public List<TblColRef> sortColumns;
    public List<OrderEnum> sortOrders;
    public boolean isRawQuery;
    public boolean limitPrecedesAggr;
    public Set<MeasureDesc> involvedMeasure;

    public SQLDigest(String factTable, Set<TblColRef> allColumns, List<JoinDesc> joinDescs, List<TblColRef> groupbyColumns, Set<TblColRef> subqueryJoinParticipants, Set<TblColRef> metricColumns, List<FunctionDesc> aggregations, List<SQLCall> aggrSqlCalls, Set<TblColRef> filterColumns, TupleFilter filter, TupleFilter havingFilter, List<TblColRef> sortColumns, List<OrderEnum> sortOrders, boolean limitPrecedesAggr, Set<MeasureDesc> involvedMeasure) {
        this.factTable = factTable;
        this.allColumns = allColumns;
        this.joinDescs = joinDescs;
        this.groupbyColumns = groupbyColumns;
        this.subqueryJoinParticipants = subqueryJoinParticipants;
        this.metricColumns = metricColumns;
        this.aggregations = aggregations;
        this.aggrSqlCalls = aggrSqlCalls;
        this.filterColumns = filterColumns;
        this.filter = filter;
        this.havingFilter = havingFilter;
        this.sortColumns = sortColumns;
        this.sortOrders = sortOrders;
        this.isRawQuery = this.isRawQuery();
        this.limitPrecedesAggr = limitPrecedesAggr;
        this.involvedMeasure = involvedMeasure;
        this.includeSubqueryJoinParticipants();
    }

    private boolean isRawQuery() {
        return this.groupbyColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public void includeSubqueryJoinParticipants() {
        if (this.isRawQuery) {
            this.allColumns.addAll(this.subqueryJoinParticipants);
        } else {
            this.groupbyColumns.addAll(this.subqueryJoinParticipants);
            this.allColumns.addAll(this.subqueryJoinParticipants);
        }
    }

    public String toString() {
        return "fact table " + this.factTable + "," + "group by " + this.groupbyColumns + "," + "filter on " + this.filterColumns + "," + "with aggregates" + this.aggregations + ".";
    }

    public static class SQLCall {
        public final String function;
        public final List<Object> args;

        public SQLCall(String function, Iterable<Object> args) {
            this.function = function;
            this.args = ImmutableList.copyOf(args);
        }
    }

    public static enum OrderEnum {
        ASCENDING,
        DESCENDING;

    }
}

