/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.ISourceAware;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableDesc
extends RootPersistentEntity
implements ISourceAware {
    private static final String TABLE_TYPE_VIRTUAL_VIEW = "VIRTUAL_VIEW";
    private static final String materializedTableNamePrefix = "kylin_intermediate_";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="columns")
    private ColumnDesc[] columns;
    @JsonProperty(value="source_type")
    private int sourceType = 0;
    @JsonProperty(value="table_type")
    private String tableType;
    @JsonProperty(value="data_gen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataGen;
    private String project;
    private DatabaseDesc database = new DatabaseDesc();
    private String identity = null;

    public TableDesc() {
    }

    public TableDesc(TableDesc other) {
        this.uuid = other.uuid;
        this.lastModified = other.lastModified;
        this.name = other.name;
        this.sourceType = other.sourceType;
        this.tableType = other.tableType;
        this.dataGen = other.dataGen;
        this.columns = new ColumnDesc[other.columns.length];
        for (int i = 0; i < other.columns.length; ++i) {
            this.columns[i] = new ColumnDesc(other.columns[i]);
            this.columns[i].init(this);
        }
        this.project = other.project;
        this.database.setName(other.getDatabase());
        this.identity = other.identity;
    }

    public TableDesc appendColumns(ColumnDesc[] computedColumns) {
        int i;
        if (computedColumns == null || computedColumns.length == 0) {
            return this;
        }
        TableDesc ret = new TableDesc(this);
        ColumnDesc[] origin = ret.columns;
        ret.columns = new ColumnDesc[computedColumns.length + origin.length];
        for (i = 0; i < origin.length; ++i) {
            ret.columns[i] = origin[i];
            for (int j = 0; j < computedColumns.length; ++j) {
                if (!origin[i].getName().equalsIgnoreCase(computedColumns[j].getName())) continue;
                throw new IllegalArgumentException(String.format("There is already a column named %s on table %s, please change your computed column name", computedColumns[j].getName(), this.getIdentity()));
            }
        }
        for (i = 0; i < computedColumns.length; ++i) {
            computedColumns[i].init(ret);
            ret.columns[i + this.columns.length] = computedColumns[i];
        }
        return ret;
    }

    public ColumnDesc findColumnByName(String name) {
        int lastIndexOfDot = name.lastIndexOf(".");
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        for (ColumnDesc c : this.columns) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getResourcePath() {
        return TableDesc.concatResourcePath(this.getIdentity(), this.project);
    }

    public String getResourcePathV1() {
        return TableDesc.concatResourcePath(this.name, null);
    }

    public String getIdentity() {
        if (this.identity == null) {
            this.identity = String.format("%s.%s", this.getDatabase().toUpperCase(), this.getName()).toUpperCase();
        }
        return this.identity;
    }

    public boolean isView() {
        return TABLE_TYPE_VIRTUAL_VIEW.equals(this.tableType);
    }

    public static String concatRawResourcePath(String nameOnPath) {
        return "/table/" + nameOnPath + ".json";
    }

    public static String concatResourcePath(String tableIdentity, String prj) {
        if (prj == null || prj.isEmpty()) {
            return "/table/" + tableIdentity + ".json";
        }
        return "/table/" + tableIdentity + "--" + prj + ".json";
    }

    public static Pair<String, String> parseResourcePath(String path) {
        String prj;
        String table;
        int dash;
        int cut;
        if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - ".json".length());
        }
        if ((cut = path.lastIndexOf("/")) >= 0) {
            path = path.substring(cut + 1);
        }
        if ((dash = path.indexOf("--")) >= 0) {
            table = path.substring(0, dash);
            prj = path.substring(dash + 2);
        } else {
            table = path;
            prj = null;
        }
        return Pair.newPair(table, prj);
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            String[] splits = StringSplitter.split(name, ".");
            if (splits.length == 2) {
                this.setDatabase(splits[0]);
                this.name = splits[1];
            } else if (splits.length == 1) {
                this.name = splits[0];
            }
        } else {
            this.name = null;
        }
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database.getName();
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database.setName(database);
    }

    public ColumnDesc[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnDesc[] columns) {
        this.columns = columns;
    }

    public int getMaxColumnIndex() {
        if (this.columns == null) {
            return -1;
        }
        int max = -1;
        for (ColumnDesc col : this.columns) {
            int idx = col.getZeroBasedIndex();
            max = Math.max(max, idx);
        }
        return max;
    }

    public int getColumnCount() {
        return this.getMaxColumnIndex() + 1;
    }

    public String getDataGen() {
        return this.dataGen;
    }

    public void init(String project) {
        this.project = project;
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
        if (this.getDatabase() != null) {
            this.setDatabase(this.getDatabase().toUpperCase());
        }
        if (this.columns != null) {
            Arrays.sort(this.columns, new Comparator<ColumnDesc>(){

                @Override
                public int compare(ColumnDesc col1, ColumnDesc col2) {
                    Integer id1 = Integer.parseInt(col1.getId());
                    Integer id2 = Integer.parseInt(col2.getId());
                    return id1.compareTo(id2);
                }
            });
            for (ColumnDesc col : this.columns) {
                col.init(this);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDesc tableDesc = (TableDesc)o;
        if (this.sourceType != tableDesc.sourceType) {
            return false;
        }
        if (this.name != null ? !this.name.equals(tableDesc.name) : tableDesc.name != null) {
            return false;
        }
        if (!Arrays.equals(this.columns, tableDesc.columns)) {
            return false;
        }
        return this.getIdentity().equals(tableDesc.getIdentity());
    }

    public String getMaterializedName() {
        return materializedTableNamePrefix + this.database.getName() + "_" + this.name;
    }

    public String toString() {
        return "TableDesc{name='" + this.name + '\'' + ", columns=" + Arrays.toString(this.columns) + ", sourceType=" + this.sourceType + ", tableType='" + this.tableType + '\'' + ", database=" + this.database + ", identity='" + this.getIdentity() + '\'' + '}';
    }

    public static TableDesc mockup(String tableName) {
        TableDesc mockup = new TableDesc();
        mockup.setName(tableName);
        return mockup;
    }

    @Override
    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }
}

