/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class FunctionDesc
implements Serializable {
    public static final String FUNC_SUM = "SUM";
    public static final String FUNC_MIN = "MIN";
    public static final String FUNC_MAX = "MAX";
    public static final String FUNC_COUNT = "COUNT";
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final Set<String> BUILT_IN_AGGREGATIONS = Sets.newHashSet();
    public static final String PARAMETER_TYPE_CONSTANT = "constant";
    public static final String PARAMETER_TYPE_COLUMN = "column";
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="parameter")
    private ParameterDesc parameter;
    @JsonProperty(value="returntype")
    private String returnType;
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> configuration = new LinkedHashMap<String, String>();
    private DataType returnDataType;
    private MeasureType<?> measureType;
    private boolean isDimensionAsMetric = false;

    public static FunctionDesc newInstance(String expression, ParameterDesc param, String returnType) {
        FunctionDesc r = new FunctionDesc();
        r.expression = expression == null ? null : expression.toUpperCase();
        r.parameter = param;
        r.returnType = returnType;
        r.returnDataType = DataType.getType(returnType);
        return r;
    }

    public void init(DataModelDesc model) {
        this.expression = this.expression.toUpperCase();
        this.returnDataType = DataType.getType(this.returnType);
        for (ParameterDesc p = this.parameter; p != null; p = p.getNextParameter()) {
            if (!p.isColumnType()) continue;
            TblColRef colRef = model.findColumn(p.getValue());
            p.setValue(colRef.getIdentity());
            p.setColRef(colRef);
        }
    }

    private void reInitMeasureType() {
        this.measureType = this.isDimensionAsMetric && this.isCountDistinct() ? MeasureTypeFactory.createNoRewriteFieldsMeasureType(this.getExpression(), this.getReturnDataType()) : MeasureTypeFactory.create(this.getExpression(), this.getReturnDataType());
    }

    public MeasureType<?> getMeasureType() {
        if (this.isDimensionAsMetric && !this.isCountDistinct()) {
            return null;
        }
        if (this.measureType == null) {
            this.reInitMeasureType();
        }
        return this.measureType;
    }

    public boolean needRewrite() {
        if (this.getMeasureType() == null) {
            return false;
        }
        return this.getMeasureType().needRewrite();
    }

    public boolean needRewriteField() {
        if (!this.needRewrite()) {
            return false;
        }
        return this.getMeasureType().needRewriteField();
    }

    public String getRewriteFieldName() {
        if (this.isSum()) {
            return this.getParameter().getValue();
        }
        if (this.isCount()) {
            return "_KY_COUNT__";
        }
        if (this.isCountDistinct()) {
            return "_KY_" + this.getFullExpressionInAlphabetOrder().replaceAll("[(),. ]", "_");
        }
        return "_KY_" + this.getFullExpression().replaceAll("[(),. ]", "_");
    }

    public DataType getRewriteFieldType() {
        if (this.isSum() || this.isMax() || this.isMin()) {
            return this.parameter.getColRefs().get(0).getType();
        }
        if (this.getMeasureType() instanceof BasicMeasureType) {
            return this.returnDataType;
        }
        return DataType.ANY;
    }

    public ColumnDesc newFakeRewriteColumn(TableDesc sourceTable) {
        ColumnDesc fakeCol = new ColumnDesc();
        fakeCol.setName(this.getRewriteFieldName());
        fakeCol.setDatatype(this.getRewriteFieldType().toString());
        if (this.isCount()) {
            fakeCol.setNullable(false);
        }
        fakeCol.init(sourceTable);
        return fakeCol;
    }

    public boolean isMin() {
        return FUNC_MIN.equalsIgnoreCase(this.expression);
    }

    public boolean isMax() {
        return FUNC_MAX.equalsIgnoreCase(this.expression);
    }

    public boolean isSum() {
        return FUNC_SUM.equalsIgnoreCase(this.expression);
    }

    public boolean isCount() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression);
    }

    public boolean isCountDistinct() {
        return FUNC_COUNT_DISTINCT.equalsIgnoreCase(this.expression);
    }

    public String getFullExpression() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        if (this.parameter != null) {
            sb.append(this.parameter.getValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String getFullExpressionInAlphabetOrder() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        ArrayList flatParams = Lists.newArrayList();
        for (ParameterDesc localParam = this.parameter; localParam != null; localParam = localParam.getNextParameter()) {
            flatParams.add(localParam.getValue());
        }
        Collections.sort(flatParams);
        sb.append(Joiner.on((String)",").join((Iterable)flatParams));
        sb.append(")");
        return sb.toString();
    }

    public boolean isDimensionAsMetric() {
        return this.isDimensionAsMetric;
    }

    public void setDimensionAsMetric(boolean isDimensionAsMetric) {
        this.isDimensionAsMetric = isDimensionAsMetric;
        if (this.measureType != null) {
            this.reInitMeasureType();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public ParameterDesc getParameter() {
        return this.parameter;
    }

    public int getParameterCount() {
        int count = 0;
        for (ParameterDesc p = this.parameter; p != null; p = p.getNextParameter()) {
            ++count;
        }
        return count;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public DataType getReturnDataType() {
        return this.returnDataType;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.isCount() || this.parameter == null ? 0 : this.parameter.hashCode());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDesc other = (FunctionDesc)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.isCountDistinct()) {
            if (this.parameter != null) return this.parameter.equalInArbitraryOrder(other.parameter);
            if (other.parameter == null) return true;
            return false;
        }
        if (this.isCount() || !(this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter))) return true;
        return false;
    }

    public String toString() {
        return "FunctionDesc [expression=" + this.expression + ", parameter=" + this.parameter + ", returnType=" + this.returnType + "]";
    }

    static {
        BUILT_IN_AGGREGATIONS.add(FUNC_COUNT);
        BUILT_IN_AGGREGATIONS.add(FUNC_MAX);
        BUILT_IN_AGGREGATIONS.add(FUNC_MIN);
        BUILT_IN_AGGREGATIONS.add(FUNC_SUM);
        BUILT_IN_AGGREGATIONS.add(FUNC_COUNT_DISTINCT);
    }
}

