/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.JoinsTree;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DataModelDesc
extends RootPersistentEntity {
    private static final Logger logger = LoggerFactory.getLogger(DataModelDesc.class);
    private KylinConfig config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="is_draft")
    private boolean isDraft;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="fact_table")
    private String rootFactTable;
    @JsonProperty(value="lookups")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JoinTableDesc[] joinTables;
    @JsonProperty(value="join_tables")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JoinTableDesc[] deprecatedLookups;
    @JsonProperty(value="dimensions")
    private List<ModelDimensionDesc> dimensions;
    @JsonProperty(value="metrics")
    private String[] metrics;
    @JsonProperty(value="filter_condition")
    private String filterCondition;
    @JsonProperty(value="partition_desc")
    PartitionDesc partitionDesc;
    @JsonProperty(value="capacity")
    private RealizationCapacity capacity = RealizationCapacity.MEDIUM;
    @JsonProperty(value="computed_columns")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private List<ComputedColumnDesc> computedColumnDescs = Lists.newArrayList();
    private TableRef rootFactTableRef;
    private Set<TableRef> factTableRefs = Sets.newLinkedHashSet();
    private Set<TableRef> lookupTableRefs = Sets.newLinkedHashSet();
    private Set<TableRef> allTableRefs = Sets.newLinkedHashSet();
    private Map<String, TableRef> aliasMap = Maps.newHashMap();
    private Map<String, TableRef> tableNameMap = Maps.newHashMap();
    private JoinsTree joinsTree;
    private List<String> errors = new ArrayList<String>();

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public void setDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TableRef getRootFactTable() {
        return this.rootFactTableRef;
    }

    public String getRootFactTableName() {
        return this.rootFactTable;
    }

    public void setRootFactTableName(String rootFactTable) {
        this.rootFactTable = rootFactTable;
    }

    public Set<TableRef> getAllTables() {
        return this.allTableRefs;
    }

    public Set<TableRef> getFactTables() {
        return this.factTableRefs;
    }

    public Map<String, TableRef> getAliasMap() {
        return Collections.unmodifiableMap(this.aliasMap);
    }

    public Set<TableRef> getLookupTables() {
        return this.lookupTableRefs;
    }

    public JoinTableDesc[] getJoinTables() {
        return this.joinTables;
    }

    public void setJoinTables(JoinTableDesc[] joinTables) {
        this.joinTables = joinTables;
    }

    public JoinDesc getJoinByPKSide(TableRef table) {
        return this.joinsTree.getJoinByPKSide(table);
    }

    public JoinsTree getJoinsTree() {
        return this.joinsTree;
    }

    @Deprecated
    public List<TableDesc> getLookupTableDescs() {
        ArrayList result = Lists.newArrayList();
        for (TableRef table : this.getLookupTables()) {
            result.add(table.getTableDesc());
        }
        return result;
    }

    public boolean isLookupTable(TableRef t) {
        if (t == null) {
            return false;
        }
        return this.lookupTableRefs.contains(t);
    }

    public boolean isLookupTable(String fullTableName) {
        for (TableRef t : this.lookupTableRefs) {
            if (!t.getTableIdentity().equals(fullTableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFactTable(TableRef t) {
        if (t == null) {
            return false;
        }
        return this.factTableRefs.contains(t);
    }

    public boolean isFactTable(String fullTableName) {
        for (TableRef t : this.factTableRefs) {
            if (!t.getTableIdentity().equals(fullTableName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTable(TableDesc table) {
        for (TableRef t : this.allTableRefs) {
            if (!t.getTableIdentity().equals(table.getIdentity()) || !StringUtil.equals(t.getTableDesc().getProject(), table.getProject())) continue;
            return true;
        }
        return false;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    public RealizationCapacity getCapacity() {
        return this.capacity;
    }

    public void setCapacity(RealizationCapacity capacity) {
        this.capacity = capacity;
    }

    public TblColRef findColumn(String table, String column) throws IllegalArgumentException {
        TableRef tableRef = this.findTable(table);
        TblColRef result = tableRef.getColumn(column.toUpperCase());
        if (result == null) {
            throw new IllegalArgumentException("Column not found by " + table + "." + column);
        }
        return result;
    }

    public TblColRef findColumn(String column) throws IllegalArgumentException {
        TblColRef result = null;
        String input = column;
        int cut = (column = column.toUpperCase()).lastIndexOf(46);
        if (cut > 0) {
            result = this.findColumn(column.substring(0, cut), column.substring(cut + 1));
        } else {
            TableRef tableRef;
            Iterator<TableRef> i$ = this.allTableRefs.iterator();
            while (i$.hasNext() && (result = (tableRef = i$.next()).getColumn(column)) == null) {
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Column not found by " + input);
        }
        return result;
    }

    public TableRef findTable(String table) throws IllegalArgumentException {
        TableRef result = this.tableNameMap.get(table.toUpperCase());
        if (result == null) {
            throw new IllegalArgumentException("Table not found by " + table);
        }
        return result;
    }

    public TableRef findFirstTable(String tableIdentity) throws IllegalArgumentException {
        if (this.rootFactTableRef.getTableIdentity().equals(tableIdentity)) {
            return this.rootFactTableRef;
        }
        for (TableRef fact : this.factTableRefs) {
            if (!fact.getTableIdentity().equals(tableIdentity)) continue;
            return fact;
        }
        for (TableRef lookup : this.lookupTableRefs) {
            if (!lookup.getTableIdentity().equals(tableIdentity)) continue;
            return lookup;
        }
        throw new IllegalArgumentException("Table not found by " + tableIdentity + " in model " + this.name);
    }

    public void init(KylinConfig config, Map<String, TableDesc> originalTables, List<DataModelDesc> dataModelDescs) {
        HashMap tables = Maps.newHashMap();
        for (Map.Entry<String, TableDesc> entry : originalTables.entrySet()) {
            String s = entry.getKey();
            TableDesc tableDesc = entry.getValue();
            TableDesc extendedTableDesc = tableDesc.appendColumns(this.createComputedColumns(tableDesc));
            tables.put(s, extendedTableDesc);
        }
        this.config = config;
        this.initJoinTablesForUpgrade();
        this.initTableAlias(tables);
        this.initJoinColumns();
        this.reorderJoins(tables);
        this.initJoinsTree();
        this.initDimensionsAndMetrics();
        this.initPartitionDesc();
        this.initComputedColumns(dataModelDescs);
        this.initFilterCondition();
        boolean reinit = this.validate();
        if (reinit) {
            this.init(config, tables, dataModelDescs);
        }
    }

    private ColumnDesc[] createComputedColumns(final TableDesc tableDesc) {
        final MutableInt id = new MutableInt(tableDesc.getColumnCount());
        return (ColumnDesc[])FluentIterable.from(this.computedColumnDescs).filter((Predicate)new Predicate<ComputedColumnDesc>(){

            public boolean apply(@Nullable ComputedColumnDesc input) {
                return tableDesc.getIdentity().equalsIgnoreCase(input.getTableIdentity());
            }
        }).transform((Function)new Function<ComputedColumnDesc, ColumnDesc>(){

            @Nullable
            public ColumnDesc apply(@Nullable ComputedColumnDesc input) {
                id.increment();
                ColumnDesc columnDesc = new ColumnDesc(id.toString(), input.getColumnName(), input.getDatatype(), input.getComment(), null, null, input.getExpression());
                return columnDesc;
            }
        }).toArray(ColumnDesc.class);
    }

    private void initJoinTablesForUpgrade() {
        if (this.joinTables == null) {
            this.joinTables = new JoinTableDesc[0];
        }
        if (this.deprecatedLookups != null) {
            JoinTableDesc[] copy = Arrays.copyOf(this.joinTables, this.joinTables.length + this.deprecatedLookups.length);
            System.arraycopy(this.deprecatedLookups, 0, copy, this.joinTables.length, this.deprecatedLookups.length);
            this.joinTables = copy;
            this.deprecatedLookups = null;
        }
    }

    private void initTableAlias(Map<String, TableDesc> tables) {
        this.factTableRefs.clear();
        this.lookupTableRefs.clear();
        this.allTableRefs.clear();
        this.aliasMap.clear();
        this.tableNameMap.clear();
        if (StringUtils.isEmpty((CharSequence)this.rootFactTable)) {
            throw new IllegalStateException("root fact table should not be empty");
        }
        this.rootFactTable = this.rootFactTable.toUpperCase();
        if (!tables.containsKey(this.rootFactTable)) {
            throw new IllegalStateException("Root fact table does not exist:" + this.rootFactTable);
        }
        TableDesc rootDesc = tables.get(this.rootFactTable);
        this.rootFactTableRef = new TableRef(this, rootDesc.getName(), rootDesc, false);
        this.addAlias(this.rootFactTableRef);
        this.factTableRefs.add(this.rootFactTableRef);
        for (JoinTableDesc join : this.joinTables) {
            join.setTable(join.getTable().toUpperCase());
            if (!tables.containsKey(join.getTable())) {
                throw new IllegalStateException("Join table does not exist:" + join.getTable());
            }
            TableDesc tableDesc = tables.get(join.getTable());
            String alias = join.getAlias();
            if (alias == null) {
                alias = tableDesc.getName();
            }
            alias = alias.toUpperCase();
            join.setAlias(alias);
            TableRef ref = new TableRef(this, alias, tableDesc, true);
            join.setTableRef(ref);
            this.addAlias(ref);
            (join.getKind() == TableKind.LOOKUP ? this.lookupTableRefs : this.factTableRefs).add(ref);
        }
        this.tableNameMap.putAll(this.aliasMap);
        this.allTableRefs.addAll(this.factTableRefs);
        this.allTableRefs.addAll(this.lookupTableRefs);
    }

    private void addAlias(TableRef ref) {
        String alias = ref.getAlias();
        if (this.aliasMap.containsKey(alias)) {
            throw new IllegalStateException("Alias '" + alias + "' ref to multiple tables: " + ref.getTableIdentity() + ", " + this.aliasMap.get(alias).getTableIdentity());
        }
        this.aliasMap.put(alias, ref);
        TableDesc table = ref.getTableDesc();
        this.addTableName(table.getName(), ref);
        this.addTableName(table.getIdentity(), ref);
    }

    private void addTableName(String name, TableRef ref) {
        if (this.tableNameMap.containsKey(name)) {
            this.tableNameMap.put(name, null);
        } else {
            this.tableNameMap.put(name, ref);
        }
    }

    private void initDimensionsAndMetrics() {
        for (ModelDimensionDesc dim : this.dimensions) {
            dim.init(this);
        }
        for (int i = 0; i < this.metrics.length; ++i) {
            this.metrics[i] = this.findColumn(this.metrics[i]).getIdentity();
        }
    }

    private void initPartitionDesc() {
        if (this.partitionDesc != null) {
            this.partitionDesc.init(this);
        }
    }

    private void initComputedColumns(List<DataModelDesc> allDataModelDescs) {
        Preconditions.checkNotNull(allDataModelDescs);
        ArrayList existingCCs = Lists.newArrayList();
        for (DataModelDesc dataModelDesc : allDataModelDescs) {
            if (StringUtils.equals((CharSequence)dataModelDesc.getName(), (CharSequence)this.getName())) continue;
            for (ComputedColumnDesc cc : dataModelDesc.getComputedColumnDescs()) {
                existingCCs.add(Pair.newPair(cc, dataModelDesc));
            }
        }
        for (ComputedColumnDesc newCC : this.computedColumnDescs) {
            newCC.init(this.aliasMap, this.rootFactTableRef.getAlias());
            String newCCFullName = newCC.getFullName();
            String newCCColumnName = newCC.getColumnName();
            for (Pair pair : existingCCs) {
                DataModelDesc dataModelDesc = (DataModelDesc)pair.getSecond();
                ComputedColumnDesc cc = (ComputedColumnDesc)pair.getFirst();
                if (StringUtils.equalsIgnoreCase((CharSequence)cc.getFullName(), (CharSequence)newCCFullName) && !cc.equals(newCC)) {
                    throw new IllegalArgumentException(String.format("Column name for computed column %s is already used in model %s, you should apply the same expression ' %s ' here, or use a different column name.", newCCFullName, dataModelDesc.getName(), cc.getExpression()));
                }
                if (!this.isTwoCCDefinitionEquals(cc.getExpression(), newCC.getExpression()) || StringUtils.equalsIgnoreCase((CharSequence)cc.getColumnName(), (CharSequence)newCCColumnName)) continue;
                throw new IllegalArgumentException(String.format("Expression %s in computed column %s is already defined by computed column %s from model %s, you should use the same column name: ' %s ' .", newCC.getExpression(), newCCFullName, cc.getFullName(), dataModelDesc.getName(), cc.getColumnName()));
            }
            existingCCs.add(Pair.newPair(newCC, this));
        }
    }

    private void initFilterCondition() {
        if (null == this.filterCondition) {
            return;
        }
        int quotationType = 0;
        int len = this.filterCondition.length();
        for (int i = 0; i < len; ++i) {
            if (';' == this.filterCondition.charAt(i) && 0 == quotationType) {
                throw new IllegalStateException("Filter Condition is Illegal. Please check it and make sure it's an appropriate expression for WHERE clause");
            }
            if ('\'' == this.filterCondition.charAt(i)) {
                if (quotationType > 0) {
                    if (1 == quotationType) {
                        quotationType = 0;
                        continue;
                    }
                } else if (0 == quotationType) {
                    quotationType = 1;
                    continue;
                }
            }
            if ('\"' != this.filterCondition.charAt(i)) continue;
            if (quotationType > 0) {
                if (2 != quotationType) continue;
                quotationType = 0;
                continue;
            }
            if (0 != quotationType) continue;
            quotationType = 2;
        }
    }

    private boolean isTwoCCDefinitionEquals(String definition0, String definition1) {
        definition0 = definition0.replaceAll("\\s*", "");
        definition1 = definition1.replaceAll("\\s*", "");
        return definition0.equalsIgnoreCase(definition1);
    }

    private void initJoinColumns() {
        for (JoinTableDesc joinTable : this.joinTables) {
            TableRef dimTable = joinTable.getTableRef();
            JoinDesc join = joinTable.getJoin();
            if (join == null) {
                throw new IllegalStateException("Missing join conditions on table " + dimTable);
            }
            StringUtil.toUpperCaseArray(join.getForeignKey(), join.getForeignKey());
            StringUtil.toUpperCaseArray(join.getPrimaryKey(), join.getPrimaryKey());
            Object[] pks = join.getPrimaryKey();
            TblColRef[] pkCols = new TblColRef[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                TblColRef col = dimTable.getColumn(pks[i]);
                if (col == null) {
                    col = this.findColumn(pks[i]);
                }
                if (col == null || !col.getTableRef().equals(dimTable)) {
                    throw new IllegalStateException("Can't find PK column " + pks[i] + " in table " + dimTable);
                }
                pks[i] = col.getIdentity();
                pkCols[i] = col;
            }
            join.setPrimaryKeyColumns(pkCols);
            Object[] fks = join.getForeignKey();
            TblColRef[] fkCols = new TblColRef[fks.length];
            for (int i = 0; i < fks.length; ++i) {
                TblColRef col = this.findColumn(fks[i]);
                if (col == null) {
                    throw new IllegalStateException("Can't find FK column " + fks[i]);
                }
                fks[i] = col.getIdentity();
                fkCols[i] = col;
            }
            join.setForeignKeyColumns(fkCols);
            join.sortByFK();
            TableRef fkTable = fkCols[0].getTableRef();
            if (pkCols.length == 0 || fkCols.length == 0) {
                throw new IllegalStateException("Missing join columns on table " + dimTable);
            }
            if (pkCols.length != fkCols.length) {
                throw new IllegalStateException("Primary keys(" + dimTable + ")" + Arrays.toString(pks) + " are not consistent with Foreign keys(" + fkTable + ") " + Arrays.toString(fks));
            }
            for (int i = 0; i < fkCols.length; ++i) {
                if (fkCols[i].getDatatype().equals(pkCols[i].getDatatype())) continue;
                logger.warn("PK " + dimTable + "." + pkCols[i].getName() + "." + pkCols[i].getDatatype() + " are not consistent with FK " + fkTable + "." + fkCols[i].getName() + "." + fkCols[i].getDatatype());
            }
        }
    }

    private void initJoinsTree() {
        ArrayList<JoinDesc> joins = new ArrayList<JoinDesc>();
        for (JoinTableDesc joinTable : this.joinTables) {
            joins.add(joinTable.getJoin());
        }
        this.joinsTree = new JoinsTree(this.rootFactTableRef, joins);
    }

    private void reorderJoins(Map<String, TableDesc> tables) {
        if (this.joinTables.length == 0) {
            return;
        }
        HashMap fkMap = Maps.newHashMap();
        for (JoinTableDesc joinTable : this.joinTables) {
            JoinDesc join = joinTable.getJoin();
            String fkSideName = join.getFKSide().getAlias();
            if (fkMap.containsKey(fkSideName)) {
                ((List)fkMap.get(fkSideName)).add(joinTable);
                continue;
            }
            ArrayList joinTableList = Lists.newArrayList();
            joinTableList.add(joinTable);
            fkMap.put(fkSideName, joinTableList);
        }
        JoinTableDesc[] orderedJoinTables = new JoinTableDesc[this.joinTables.length];
        int orderedIndex = 0;
        ArrayDeque joinTableBuff = new ArrayDeque();
        TableDesc rootDesc = tables.get(this.rootFactTable);
        joinTableBuff.addAll((Collection)fkMap.get(rootDesc.getName()));
        while (!joinTableBuff.isEmpty()) {
            JoinTableDesc head = (JoinTableDesc)joinTableBuff.poll();
            orderedJoinTables[orderedIndex++] = head;
            String headAlias = head.getJoin().getPKSide().getAlias();
            if (!fkMap.containsKey(headAlias)) continue;
            joinTableBuff.addAll((Collection)fkMap.get(headAlias));
        }
        this.joinTables = orderedJoinTables;
    }

    private boolean validate() {
        for (ModelDimensionDesc dim : this.dimensions) {
            String table = dim.getTable();
            for (String c : dim.getColumns()) {
                TblColRef dcol = this.findColumn(table, c);
                this.metrics = (String[])ArrayUtils.removeElement((Object[])this.metrics, (Object)dcol.getIdentity());
            }
        }
        HashSet<TblColRef> mcols = new HashSet<TblColRef>();
        for (String m : this.metrics) {
            mcols.add(this.findColumn(m));
        }
        boolean pkfkDimAmended = false;
        for (JoinsTree.Chain chain : this.joinsTree.tableChains.values()) {
            pkfkDimAmended = this.validatePkFkDim(chain.join, mcols) || pkfkDimAmended;
        }
        return pkfkDimAmended;
    }

    private boolean validatePkFkDim(JoinDesc join, Set<TblColRef> mcols) {
        if (join == null) {
            return false;
        }
        boolean pkfkDimAmended = false;
        for (TblColRef c : join.getForeignKeyColumns()) {
            if (mcols.contains(c)) continue;
            pkfkDimAmended = this.validatePkFkDim(c) || pkfkDimAmended;
        }
        for (TblColRef c : join.getPrimaryKeyColumns()) {
            if (mcols.contains(c)) continue;
            pkfkDimAmended = this.validatePkFkDim(c) || pkfkDimAmended;
        }
        return pkfkDimAmended;
    }

    private boolean validatePkFkDim(TblColRef c) {
        String t = c.getTableAlias();
        ModelDimensionDesc dimDesc = null;
        for (ModelDimensionDesc dim : this.dimensions) {
            if (!dim.getTable().equals(t)) continue;
            dimDesc = dim;
            break;
        }
        if (dimDesc == null) {
            dimDesc = new ModelDimensionDesc();
            dimDesc.setTable(t);
            dimDesc.setColumns(new String[0]);
            this.dimensions.add(dimDesc);
        }
        if (!ArrayUtils.contains((Object[])dimDesc.getColumns(), (Object)c.getName())) {
            String[] newCols = (String[])ArrayUtils.add((Object[])dimDesc.getColumns(), (Object)c.getName());
            dimDesc.setColumns(newCols);
            return true;
        }
        return false;
    }

    public void addError(String message) {
        this.addError(message, false);
    }

    public void addError(String message, boolean silent) {
        if (!silent) {
            throw new IllegalStateException(message);
        }
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelDesc modelDesc = (DataModelDesc)o;
        if (!this.name.equals(modelDesc.name)) {
            return false;
        }
        return this.getRootFactTable().equals(modelDesc.getRootFactTable());
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.getRootFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "DataModelDesc [name=" + this.name + "]";
    }

    public String getResourcePath() {
        return DataModelDesc.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String descName) {
        return "/model_desc/" + descName + ".json";
    }

    public List<ModelDimensionDesc> getDimensions() {
        return this.dimensions;
    }

    public ComputedColumnDesc findCCByCCColumnName(final String columnName) {
        return (ComputedColumnDesc)Iterables.find(this.computedColumnDescs, (Predicate)new Predicate<ComputedColumnDesc>(){

            public boolean apply(@Nullable ComputedColumnDesc input) {
                Preconditions.checkNotNull((Object)input);
                return columnName.equals(input.getColumnName());
            }
        });
    }

    public Set<String> getComputedColumnNames() {
        HashSet ccColumnNames = Sets.newHashSet();
        for (ComputedColumnDesc cc : this.getComputedColumnDescs()) {
            ccColumnNames.add(cc.getColumnName());
        }
        return Collections.unmodifiableSet(ccColumnNames);
    }

    public List<ComputedColumnDesc> getComputedColumnDescs() {
        return this.computedColumnDescs;
    }

    public void setComputedColumnDescs(List<ComputedColumnDesc> computedColumnDescs) {
        this.computedColumnDescs = computedColumnDescs;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public void setDimensions(List<ModelDimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public void setMetrics(String[] metrics) {
        this.metrics = metrics;
    }

    public String getProject() {
        return ProjectManager.getInstance(this.getConfig()).getProjectOfModel(this.getName()).getName();
    }

    public ProjectInstance getProjectInstance() {
        return ProjectManager.getInstance(this.getConfig()).getProjectOfModel(this.getName());
    }

    public static DataModelDesc getCopyOf(DataModelDesc orig) {
        DataModelDesc copy = new DataModelDesc();
        copy.config = orig.config;
        copy.name = orig.name;
        copy.isDraft = orig.isDraft;
        copy.owner = orig.owner;
        copy.description = orig.description;
        copy.rootFactTable = orig.rootFactTable;
        copy.joinTables = orig.joinTables;
        copy.dimensions = orig.dimensions;
        copy.metrics = orig.metrics;
        copy.filterCondition = orig.filterCondition;
        copy.capacity = orig.capacity;
        copy.computedColumnDescs = orig.computedColumnDescs;
        if (orig.getPartitionDesc() != null) {
            copy.partitionDesc = PartitionDesc.getCopyOf(orig.getPartitionDesc());
        }
        copy.updateRandomUuid();
        return copy;
    }

    public static enum RealizationCapacity implements Serializable
    {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static enum TableKind implements Serializable
    {
        FACT,
        LOOKUP;

    }
}

