/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ComputedColumnDesc
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ComputedColumnDesc.class);
    @JsonProperty
    private String tableIdentity;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tableAlias;
    @JsonProperty
    private String columnName;
    @JsonProperty
    private String expression;
    @JsonProperty
    private String datatype;
    @JsonProperty
    private String comment;

    public void init(Map<String, TableRef> aliasMap, String rootFactTableName) {
        Set<String> aliasSet = aliasMap.keySet();
        Preconditions.checkNotNull((Object)this.tableIdentity, (Object)"tableIdentity is null");
        Preconditions.checkNotNull((Object)this.columnName, (Object)"columnName is null");
        Preconditions.checkNotNull((Object)this.expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)this.datatype, (Object)"datatype is null");
        if (this.tableAlias == null) {
            this.tableAlias = this.tableIdentity.substring(this.tableIdentity.indexOf(".") + 1);
        }
        Preconditions.checkState((boolean)this.tableIdentity.equals(this.tableIdentity.trim()), (Object)"tableIdentity of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.tableAlias.equals(this.tableAlias.trim()), (Object)"tableAlias of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.columnName.equals(this.columnName.trim()), (Object)"columnName of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.datatype.equals(this.datatype.trim()), (Object)"datatype of ComputedColumnDesc has heading/tailing whitespace");
        this.tableIdentity = this.tableIdentity.toUpperCase();
        this.tableAlias = this.tableAlias.toUpperCase();
        this.columnName = this.columnName.toUpperCase();
        if (!this.tableIdentity.contains(rootFactTableName) || !this.tableAlias.equals(rootFactTableName)) {
            throw new IllegalArgumentException("Computed column has to be defined on fact table");
        }
        for (TableRef tableRef : aliasMap.values()) {
            if (rootFactTableName.equals(tableRef.getAlias())) continue;
            for (TblColRef tblColRef : tableRef.getColumns()) {
                if (!this.columnName.equals(tblColRef.getName())) continue;
                throw new IllegalArgumentException("Computed column name " + this.columnName + " is already found on table " + tableRef.getTableIdentity() + ", use a different computed column name");
            }
        }
        if ("true".equals(System.getProperty("needCheckCC"))) {
            try {
                this.simpleParserCheck(this.expression, aliasSet);
            }
            catch (Exception e) {
                String legacyHandled = this.handleLegacyCC(this.expression, rootFactTableName, aliasSet);
                if (legacyHandled != null) {
                    this.expression = legacyHandled;
                }
                throw e;
            }
        }
    }

    private String handleLegacyCC(String expr, String rootFact, Set<String> aliasSet) {
        try {
            CalciteParser.ensureNoAliasInExpr(expr);
            String ret = CalciteParser.insertAliasInExpr(expr, rootFact);
            this.simpleParserCheck(ret, aliasSet);
            return ret;
        }
        catch (Exception e) {
            logger.error("failed to handle legacy CC " + expr);
            return null;
        }
    }

    public void simpleParserCheck(final String expr, final Set<String> aliasSet) {
        SqlNode sqlNode = CalciteParser.getExpNode(expr);
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            public Object visit(SqlIdentifier id) {
                if (id.names.size() != 2 || !aliasSet.contains(id.names.get(0))) {
                    throw new IllegalArgumentException("Column Identifier in the computed column " + expr + "expression should comply to ALIAS.COLUMN ");
                }
                return null;
            }

            public Object visit(SqlCall call) {
                if (call instanceof SqlBasicCall && call.getOperator() instanceof SqlAsOperator) {
                    throw new IllegalArgumentException("Computed column expression " + expr + " should not contain AS ");
                }
                return call.getOperator().acceptCall((SqlVisitor)this, call);
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
    }

    public String getFullName() {
        return this.tableIdentity + "." + this.columnName;
    }

    public String getTableIdentity() {
        return this.tableIdentity;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedColumnDesc that = (ComputedColumnDesc)o;
        if (!this.tableIdentity.equals(that.tableIdentity)) {
            return false;
        }
        if (!StringUtils.equals((String)this.tableAlias, (String)that.tableAlias)) {
            return false;
        }
        if (!this.columnName.equals(that.columnName)) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.datatype.equals(that.datatype);
    }

    public int hashCode() {
        int result = this.tableIdentity.hashCode();
        if (this.tableAlias != null) {
            result = 31 * result + this.tableAlias.hashCode();
        }
        result = 31 * result + this.columnName.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.datatype.hashCode();
        return result;
    }
}

