/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster {
    private static final Logger logger = LoggerFactory.getLogger(Broadcaster.class);
    public static final String SYNC_ALL = "all";
    public static final String SYNC_PRJ_SCHEMA = "project_schema";
    public static final String SYNC_PRJ_DATA = "project_data";
    public static final String SYNC_PRJ_ACL = "project_acl";
    private static final ConcurrentMap<KylinConfig, Broadcaster> CACHE = new ConcurrentHashMap<KylinConfig, Broadcaster>();
    static final Map<String, List<Listener>> staticListenerMap = Maps.newConcurrentMap();
    private KylinConfig config;
    private BlockingDeque<BroadcastEvent> broadcastEvents = new LinkedBlockingDeque<BroadcastEvent>();
    private Map<String, List<Listener>> listenerMap = Maps.newConcurrentMap();
    private AtomicLong counter = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Broadcaster getInstance(KylinConfig config) {
        ConcurrentMap<KylinConfig, Broadcaster> concurrentMap = CACHE;
        synchronized (concurrentMap) {
            Broadcaster r = (Broadcaster)CACHE.get(config);
            if (r != null) {
                return r;
            }
            r = new Broadcaster(config);
            CACHE.put(config, r);
            if (CACHE.size() > 1) {
                logger.warn("More than one singleton exist");
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        ConcurrentMap<KylinConfig, Broadcaster> concurrentMap = CACHE;
        synchronized (concurrentMap) {
            CACHE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(KylinConfig kylinConfig) {
        if (kylinConfig != null) {
            ConcurrentMap<KylinConfig, Broadcaster> concurrentMap = CACHE;
            synchronized (concurrentMap) {
                CACHE.remove(kylinConfig);
            }
        }
    }

    private Broadcaster(final KylinConfig config) {
        this.config = config;
        final int retryLimitTimes = config.getCacheSyncRetrys();
        Object[] nodes = config.getRestServers();
        if (nodes == null || nodes.length < 1) {
            logger.warn("There is no available rest server; check the 'kylin.server.cluster-servers' config");
        }
        logger.debug(nodes.length + " nodes in the cluster: " + Arrays.toString(nodes));
        Executors.newSingleThreadExecutor(new DaemonThreadFactory()).execute(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                restClientMap = Maps.newHashMap();
                wipingCachePool = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
                while (true) {
                    try {
                        block3: while (true) {
                            broadcastEvent = (BroadcastEvent)Broadcaster.access$000(Broadcaster.this).takeFirst();
                            broadcastEvent.setRetryTime(broadcastEvent.getRetryTime() + 1);
                            if (broadcastEvent.getRetryTime() > retryLimitTimes) {
                                Broadcaster.access$100().info("broadcastEvent retry up to limit times, broadcastEvent:{}", (Object)broadcastEvent);
                                continue;
                            }
                            restServers = config.getRestServers();
                            Broadcaster.access$100().debug("Servers in the cluster: " + Arrays.toString(restServers));
                            for (Object node : restServers) {
                                if (restClientMap.containsKey(node)) continue;
                                restClientMap.put(node, new RestClient((String)node));
                            }
                            Broadcaster.access$100().debug("Announcing new broadcast event: " + broadcastEvent);
                            arr$ = restServers;
                            len$ = arr$.length;
                            i$ = 0;
                            while (true) {
                                if (i$ < len$) ** break;
                                continue block3;
                                node = arr$[i$];
                                wipingCachePool.execute(new Runnable((String)node, broadcastEvent){
                                    final /* synthetic */ String val$node;
                                    final /* synthetic */ BroadcastEvent val$broadcastEvent;
                                    {
                                        this.val$node = string;
                                        this.val$broadcastEvent = broadcastEvent;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            ((RestClient)restClientMap.get(this.val$node)).wipeCache(this.val$broadcastEvent.getEntity(), this.val$broadcastEvent.getEvent(), this.val$broadcastEvent.getCacheKey());
                                        }
                                        catch (IOException e) {
                                            logger.warn("Thread failed during wipe cache at {}, error msg: {}", (Object)this.val$broadcastEvent, (Object)e);
                                            try {
                                                Broadcaster.this.broadcastEvents.putLast(this.val$broadcastEvent);
                                            }
                                            catch (InterruptedException ex) {
                                                logger.warn("error reentry failed broadcastEvent to queue, broacastEvent:{}, error: {} ", (Object)this.val$broadcastEvent, (Object)ex);
                                            }
                                        }
                                    }
                                });
                                ++i$;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Broadcaster.access$100().error("error running wiping", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public void registerStaticListener(Listener listener, String ... entities) {
        Broadcaster.doRegisterListener(staticListenerMap, listener, entities);
    }

    public void registerListener(Listener listener, String ... entities) {
        Broadcaster.doRegisterListener(this.listenerMap, listener, entities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRegisterListener(Map<String, List<Listener>> lmap, Listener listener, String ... entities) {
        Map<String, List<Listener>> map = lmap;
        synchronized (map) {
            List<Listener> all = lmap.get(SYNC_ALL);
            if (all != null && all.contains(listener)) {
                return;
            }
            for (String entity : entities) {
                if (StringUtils.isBlank((String)entity)) continue;
                Broadcaster.addListener(lmap, entity, listener);
            }
            Broadcaster.addListener(lmap, SYNC_ALL, listener);
            Broadcaster.addListener(lmap, SYNC_PRJ_SCHEMA, listener);
            Broadcaster.addListener(lmap, SYNC_PRJ_DATA, listener);
            Broadcaster.addListener(lmap, SYNC_PRJ_ACL, listener);
        }
    }

    private static void addListener(Map<String, List<Listener>> lmap, String entity, Listener listener) {
        List<Listener> list = lmap.get(entity);
        if (list == null) {
            list = new ArrayList<Listener>();
            lmap.put(entity, list);
        }
        list.add(listener);
    }

    public void notifyClearAll() throws IOException {
        this.notifyListener(SYNC_ALL, Event.UPDATE, SYNC_ALL);
    }

    public void notifyProjectSchemaUpdate(String project) throws IOException {
        this.notifyListener(SYNC_PRJ_SCHEMA, Event.UPDATE, project);
    }

    public void notifyProjectDataUpdate(String project) throws IOException {
        this.notifyListener(SYNC_PRJ_DATA, Event.UPDATE, project);
    }

    public void notifyProjectACLUpdate(String project) throws IOException {
        this.notifyListener(SYNC_PRJ_ACL, Event.UPDATE, project);
    }

    public void notifyListener(String entity, Event event, String cacheKey) throws IOException {
        this.notifyListener(entity, event, cacheKey, true);
    }

    public void notifyNonStaticListener(String entity, Event event, String cacheKey) throws IOException {
        this.notifyListener(entity, event, cacheKey, false);
    }

    private void notifyListener(String entity, Event event, String cacheKey, boolean includeStatic) throws IOException {
        List<Listener> l2;
        ArrayList list = Lists.newArrayList();
        List<Listener> l1 = this.listenerMap.get(entity);
        if (l1 != null) {
            list.addAll(l1);
        }
        if (includeStatic && (l2 = staticListenerMap.get(entity)) != null) {
            list.addAll(l2);
        }
        if (list.isEmpty()) {
            return;
        }
        logger.debug("Broadcasting" + (Object)((Object)event) + ", " + entity + ", " + cacheKey);
        switch (entity) {
            case "all": {
                for (Listener l : list) {
                    l.onClearAll(this);
                }
                Broadcaster.clearCache();
                break;
            }
            case "project_schema": {
                ProjectManager.getInstance(this.config).clearL2Cache();
                for (Listener l : list) {
                    l.onProjectSchemaChange(this, cacheKey);
                }
                break;
            }
            case "project_data": {
                ProjectManager.getInstance(this.config).clearL2Cache();
                for (Listener l : list) {
                    l.onProjectDataChange(this, cacheKey);
                }
                break;
            }
            case "project_acl": {
                ProjectManager.getInstance(this.config).clearL2Cache();
                for (Listener l : list) {
                    l.onProjectQueryACLChange(this, cacheKey);
                }
                break;
            }
            default: {
                for (Listener l : list) {
                    l.onEntityChange(this, entity, event, cacheKey);
                }
            }
        }
        logger.debug("Done broadcasting" + (Object)((Object)event) + ", " + entity + ", " + cacheKey);
    }

    public void queue(String entity, String event, String key) {
        if (this.broadcastEvents == null) {
            return;
        }
        try {
            this.counter.incrementAndGet();
            this.broadcastEvents.putLast(new BroadcastEvent(entity, event, key));
        }
        catch (Exception e) {
            this.counter.decrementAndGet();
            logger.error("error putting BroadcastEvent", (Throwable)e);
        }
    }

    public long getCounterAndClear() {
        return this.counter.getAndSet(0L);
    }

    public static class BroadcastEvent {
        private int retryTime;
        private String entity;
        private String event;
        private String cacheKey;

        public BroadcastEvent(String entity, String event, String cacheKey) {
            this.entity = entity;
            this.event = event;
            this.cacheKey = cacheKey;
        }

        public int getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(int retryTime) {
            this.retryTime = retryTime;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getEvent() {
            return this.event;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
            result = 31 * result + (this.cacheKey == null ? 0 : this.cacheKey.hashCode());
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BroadcastEvent other = (BroadcastEvent)obj;
            if (!StringUtils.equals((String)this.event, (String)other.event)) {
                return false;
            }
            if (!StringUtils.equals((String)this.cacheKey, (String)other.cacheKey)) {
                return false;
            }
            return StringUtils.equals((String)this.entity, (String)other.entity);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("entity", (Object)this.entity).add("event", (Object)this.event).add("cacheKey", (Object)this.cacheKey).toString();
        }
    }

    public static abstract class Listener {
        public void onClearAll(Broadcaster broadcaster) throws IOException {
        }

        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
        }

        public void onProjectDataChange(Broadcaster broadcaster, String project) throws IOException {
        }

        public void onProjectQueryACLChange(Broadcaster broadcaster, String project) throws IOException {
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Event event, String cacheKey) throws IOException {
        }
    }

    public static enum Event {
        CREATE("create"),
        UPDATE("update"),
        DROP("drop");

        private String text;

        private Event(String text) {
            this.text = text;
        }

        public String getType() {
            return this.text;
        }

        public static Event getEvent(String event) {
            for (Event one : Event.values()) {
                if (!one.getType().equalsIgnoreCase(event)) continue;
                return one;
            }
            return null;
        }
    }
}

