/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.acl.TableACL;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableACLManager {
    private static final Logger logger = LoggerFactory.getLogger(TableACLManager.class);
    private static final Serializer<TableACL> TABLE_ACL_SERIALIZER = new JsonSerializer<TableACL>(TableACL.class);
    private static final String DIR_PREFIX = "/table_acl/";
    private static final ConcurrentMap<KylinConfig, TableACLManager> CACHE = new ConcurrentHashMap<KylinConfig, TableACLManager>();
    private KylinConfig config;
    private CaseInsensitiveStringCache<TableACL> tableACLMap;

    public static TableACLManager getInstance(KylinConfig config) {
        TableACLManager r = (TableACLManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<TableACLManager> clazz = TableACLManager.class;
        synchronized (TableACLManager.class) {
            r = (TableACLManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new TableACLManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init CubeDescManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void clearCache(KylinConfig kylinConfig) {
        if (kylinConfig != null) {
            CACHE.remove(kylinConfig);
        }
    }

    public TableACLManager(KylinConfig config) throws IOException {
        logger.info("Initializing TableACLManager with config " + config);
        this.config = config;
        this.tableACLMap = new CaseInsensitiveStringCache(config, "table_acl");
        this.loadAllTableACL();
        Broadcaster.getInstance(config).registerListener(new TableACLSyncListener(), "table_acl");
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public TableACL getTableACLByCache(String project) {
        TableACL tableACL = (TableACL)this.tableACLMap.get(project);
        if (tableACL == null) {
            return new TableACL();
        }
        return tableACL;
    }

    private void loadAllTableACL() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/table_acl", "");
        int prefixLen = DIR_PREFIX.length();
        for (String path : paths) {
            String project = path.substring(prefixLen, path.length());
            this.reloadTableACL(project);
        }
        logger.info("Loading table ACL from folder " + store.getReadableResourcePath("/table_acl"));
    }

    private void reloadTableACL(String project) throws IOException {
        TableACL tableACLRecord = this.getTableACL(project);
        this.tableACLMap.putLocal(project, tableACLRecord);
    }

    private TableACL getTableACL(String project) throws IOException {
        String path = DIR_PREFIX + project;
        TableACL tableACLRecord = this.getStore().getResource(path, TableACL.class, TABLE_ACL_SERIALIZER);
        if (tableACLRecord == null || tableACLRecord.getUserTableBlackList() == null) {
            return new TableACL();
        }
        return tableACLRecord;
    }

    public void addTableACL(String project, String username, String table) throws IOException {
        String path = DIR_PREFIX + project;
        TableACL tableACL = this.getTableACL(project).add(username, table);
        this.getStore().putResource(path, tableACL, System.currentTimeMillis(), TABLE_ACL_SERIALIZER);
        this.tableACLMap.put(project, tableACL);
    }

    public void deleteTableACL(String project, String username, String table) throws IOException {
        String path = DIR_PREFIX + project;
        TableACL tableACL = this.getTableACL(project).delete(username, table);
        this.getStore().putResource(path, tableACL, System.currentTimeMillis(), TABLE_ACL_SERIALIZER);
        this.tableACLMap.put(project, tableACL);
    }

    public void deleteTableACL(String project, String username) throws IOException {
        String path = DIR_PREFIX + project;
        TableACL tableACL = this.getTableACL(project).delete(username);
        this.getStore().putResource(path, tableACL, System.currentTimeMillis(), TABLE_ACL_SERIALIZER);
        this.tableACLMap.put(project, tableACL);
    }

    public void deleteTableACLByTbl(String project, String table) throws IOException {
        String path = DIR_PREFIX + project;
        TableACL tableACL = this.getTableACL(project).deleteByTbl(table);
        this.getStore().putResource(path, tableACL, System.currentTimeMillis(), TABLE_ACL_SERIALIZER);
        this.tableACLMap.put(project, tableACL);
    }

    private class TableACLSyncListener
    extends Broadcaster.Listener {
        private TableACLSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            TableACLManager.clearCache();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            TableACLManager.this.reloadTableACL(cacheKey);
            broadcaster.notifyProjectACLUpdate(cacheKey);
        }
    }
}

